/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.db;

import java.util.HashMap;
import java.util.Map;
import org.apache.uima.ducc.common.persistence.rm.IRmPersistence;
import org.apache.uima.ducc.common.persistence.rm.RmPersistenceFactory;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.ws.db.DbMachine;
import org.apache.uima.ducc.ws.db.IDbMachine;

public class DbQuery {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)DbQuery.class.getName());
    private static DuccId jobid = null;
    private static DbQuery instance = null;
    private static boolean enabled = true;
    private IRmPersistence persistence = null;
    private static String component = "WS";

    private DbQuery() {
        DuccPropertiesResolver dpr = DuccPropertiesResolver.getInstance();
        String value = dpr.getProperty("ducc.database.host");
        if (value != null && value.equalsIgnoreCase("--disabled--")) {
            enabled = false;
        }
        this.persistence = RmPersistenceFactory.getInstance((String)this.getClass().getName(), (String)component);
    }

    public static DbQuery getInstance() {
        return instance;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public boolean isUp() {
        return this.getMapMachines().size() > 0;
    }

    public static void dumpMap(Map<String, IDbMachine> dbMachineMap) {
        String location = "dumpMap";
        if (dbMachineMap != null) {
            if (!dbMachineMap.isEmpty()) {
                for (Map.Entry<String, IDbMachine> entry : dbMachineMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue().getIp();
                    logger.debug(location, jobid, new Object[]{"host=" + key + " " + "ip=" + value});
                }
            } else {
                logger.debug(location, jobid, new Object[]{"map is empty"});
            }
        } else {
            logger.debug(location, jobid, new Object[]{"map is null"});
        }
    }

    public Map<String, IDbMachine> getMapMachines() {
        HashMap<String, IDbMachine> retVal;
        block6: {
            String location = "getMapMachines";
            retVal = new HashMap<String, IDbMachine>();
            if (this.isEnabled()) {
                try {
                    Map state = this.persistence.getAllMachines();
                    if (!state.isEmpty()) {
                        for (String key : state.keySet()) {
                            Map entry = (Map)state.get(key);
                            DbMachine value = new DbMachine(entry);
                            retVal.put(key, value);
                        }
                        break block6;
                    }
                    logger.info(location, jobid, new Object[]{"map is empty"});
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            } else {
                logger.info(location, jobid, new Object[]{"enabled=" + enabled});
            }
        }
        DbQuery.dumpMap(retVal);
        return retVal;
    }

    public void close() {
        if (this.persistence != null) {
            this.persistence.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<DbQuery> clazz = DbQuery.class;
        synchronized (DbQuery.class) {
            if (instance == null) {
                instance = new DbQuery();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

