/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.authentication;

import org.apache.uima.ducc.common.authentication.AuthenticationResult;
import org.apache.uima.ducc.common.authentication.IAuthenticationManager;
import org.apache.uima.ducc.common.authentication.IAuthenticationResult;
import org.apache.uima.ducc.ws.authentication.AbstractAuthenticator;
import org.apache.uima.ducc.ws.authentication.UserAuthenticate;

public class LinuxAuthenticationManager
extends AbstractAuthenticator {
    private static IAuthenticationManager instance = new LinuxAuthenticationManager();
    private String version = "ducc linux 1.0";

    public static IAuthenticationManager getInstance() {
        return instance;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isPasswordChecked() {
        return true;
    }

    public IAuthenticationResult isAuthenticate(String userid, String domain, String password) {
        AuthenticationResult ar = new AuthenticationResult(true);
        try {
            ar = this.checkUserExcluded(userid);
            if (ar.isSuccess() && (ar = this.checkUserNotIncluded(userid)).isSuccess()) {
                UserAuthenticate instance = new UserAuthenticate();
                String[] args = new String[]{userid, password};
                String result = instance.launch(args);
                if (result.startsWith("success")) {
                    result = result.trim();
                    result = result.replace("success groups =", "");
                    result = result.replace("[", "");
                    result = result.replace("]", "");
                    String[] groups = (result = result.replace(" ", "")).split(",");
                    if (groups != null) {
                        this.userGroupsCache.put(userid, groups);
                    } else {
                        this.userGroupsCache.remove(userid);
                    }
                } else {
                    ar.setFailure();
                    result = result.replace("failure pam", "pam");
                    ar.setReason(result);
                }
            }
        }
        catch (Exception e) {
            ar.setFailure();
            ar.setException(e);
        }
        return ar;
    }

    @Override
    public IAuthenticationResult isGroupMember(String userid, String domain, IAuthenticationManager.Role role) {
        return super.isGroupMember(userid, domain, role);
    }
}

