/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetworkUtil {
    public static InetAddress getLocalHostAddress() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        if (!localhost.isLoopbackAddress()) {
            return localhost;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    return address;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return localhost;
    }
}

