/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.file;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebXmlFile {
    private static final Logger log = LoggerFactory.getLogger(WebXmlFile.class);

    public final String getFilterPath(FilterConfig filterConfig) {
        return this.getFilterPath(filterConfig.getServletContext(), filterConfig.getFilterName());
    }

    public final String getFilterPath(ServletContext servletContext, String filterName) {
        InputStream is = servletContext.getResourceAsStream("/WEB-INF/web.xml");
        if (is != null) {
            try {
                return this.getFilterPath(filterName, is);
            }
            catch (ParserConfigurationException ex) {
                log.error("Error reading servlet/filter path from web.xml", (Throwable)ex);
            }
            catch (SAXException ex) {
                log.error("Error reading servlet/filter path from web.xml", (Throwable)ex);
            }
            catch (IOException ex) {
                log.error("Error reading servlet/filter path from web.xml", (Throwable)ex);
            }
            catch (SecurityException e) {
                log.info("Couldn't read web.xml to automatically pick up servlet/filter path: " + e.getMessage());
            }
        }
        return null;
    }

    public final String getFilterPath(String filterName, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(is);
        String mapping = "filter-mapping";
        String name = "filter-name";
        String urlPattern = this.getFilterPath(filterName, mapping, name, document.getChildNodes());
        return urlPattern.substring(1, urlPattern.length() - 1);
    }

    private String getFilterPath(String filterName, String name, Node node) {
        String foundUrlPattern = null;
        String foundFilterName = null;
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node n = node.getChildNodes().item(i);
            if (name.equals(n.getNodeName())) {
                foundFilterName = n.getTextContent();
                continue;
            }
            if (!"url-pattern".equals(n.getNodeName())) continue;
            foundUrlPattern = n.getTextContent();
        }
        if (foundFilterName != null) {
            foundFilterName = foundFilterName.trim();
        }
        if (filterName.equals(foundFilterName)) {
            return foundUrlPattern != null ? foundUrlPattern.trim() : null;
        }
        return null;
    }

    private String getFilterPath(String filterName, String mapping, String name, NodeList nodeList) {
        String path = null;
        for (int i = 0; i < nodeList.getLength() && path == null; ++i) {
            Node node = nodeList.item(i);
            path = mapping.equals(node.getNodeName()) ? this.getFilterPath(filterName, name, node) : this.getFilterPath(filterName, mapping, name, node.getChildNodes());
        }
        return path;
    }
}

