/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.wicket.util.license.CssLicenseHeaderHandler;
import org.apache.wicket.util.license.HtmlLicenseHeaderHandler;
import org.apache.wicket.util.license.ILicenseHeaderHandler;
import org.apache.wicket.util.license.JavaLicenseHeaderHandler;
import org.apache.wicket.util.license.JavaScriptLicenseHeaderHandler;
import org.apache.wicket.util.license.PropertiesLicenseHeaderHandler;
import org.apache.wicket.util.license.VelocityLicenseHeaderHandler;
import org.apache.wicket.util.license.XmlLicenseHeaderHandler;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ApacheLicenseHeaderTestCase
extends TestCase {
    private static final String LINE_ENDING = System.getProperty("line.separator");
    private ILicenseHeaderHandler[] licenseHeaderHandlers;
    private File baseDirectory = new File("").getAbsoluteFile();
    protected String[] javaIgnore;
    protected String[] htmlIgnore;
    protected String[] propertiesIgnore;
    protected String[] xmlIgnore;
    protected String[] cssIgnore;
    protected String[] velocityIgnore;
    protected String[] javaScriptIgnore;
    protected boolean addHeaders = false;

    public ApacheLicenseHeaderTestCase() {
        super("Test of the legal aspects of the Wicket source code is correct.");
    }

    public final void setUp() {
        String property = System.getProperty("basedir");
        if (!Strings.isEmpty(property)) {
            this.baseDirectory = new File(property).getAbsoluteFile();
        }
    }

    public void testLicenseHeaders() {
        this.licenseHeaderHandlers = new ILicenseHeaderHandler[]{new JavaLicenseHeaderHandler(this.javaIgnore), new JavaScriptLicenseHeaderHandler(this.javaScriptIgnore), new XmlLicenseHeaderHandler(this.xmlIgnore), new PropertiesLicenseHeaderHandler(this.propertiesIgnore), new CssLicenseHeaderHandler(this.cssIgnore), new HtmlLicenseHeaderHandler(this.htmlIgnore), new VelocityLicenseHeaderHandler(this.velocityIgnore)};
        final HashMap<ILicenseHeaderHandler, List<File>> badFiles = new HashMap<ILicenseHeaderHandler, List<File>>();
        for (int i = 0; i < this.licenseHeaderHandlers.length; ++i) {
            final ILicenseHeaderHandler licenseHeaderHandler = this.licenseHeaderHandlers[i];
            this.visitFiles(licenseHeaderHandler.getSuffixes(), licenseHeaderHandler.getIgnoreFiles(), new FileVisitor(){

                public void visitFile(File file) {
                    if (!(licenseHeaderHandler.checkLicenseHeader(file) || ApacheLicenseHeaderTestCase.this.addHeaders && licenseHeaderHandler.addLicenseHeader(file))) {
                        ArrayList<File> files = (ArrayList<File>)badFiles.get(licenseHeaderHandler);
                        if (files == null) {
                            files = new ArrayList<File>();
                            badFiles.put(licenseHeaderHandler, files);
                        }
                        files.add(file);
                    }
                }
            });
        }
        this.failIncorrectLicenceHeaders(badFiles);
    }

    private void failIncorrectLicenceHeaders(Map<ILicenseHeaderHandler, List<File>> files) {
        if (files.size() > 0) {
            StringBuffer failString = new StringBuffer();
            for (Map.Entry<ILicenseHeaderHandler, List<File>> entry : files.entrySet()) {
                ILicenseHeaderHandler licenseHeaderHandler = entry.getKey();
                List<File> fileList = entry.getValue();
                failString.append("\n");
                failString.append(licenseHeaderHandler.getClass().getName());
                failString.append(" failed. The following files(");
                failString.append(fileList.size());
                failString.append(") didn't have correct license header:\n");
                for (File file : fileList) {
                    String filename = file.getAbsolutePath();
                    String licenseType = licenseHeaderHandler.getLicenseType(file);
                    if (licenseType == null) {
                        failString.append("NONE");
                    } else {
                        failString.append(licenseType);
                    }
                    failString.append(" ").append(filename).append(LINE_ENDING);
                }
            }
            System.out.println(failString);
            ApacheLicenseHeaderTestCase.fail((String)failString.toString());
        }
    }

    private void visitFiles(String[] suffixes, String[] ignoreFiles, FileVisitor fileVisitor) {
        this.visitDirectory(suffixes, ignoreFiles, this.baseDirectory, fileVisitor);
    }

    private void visitDirectory(String[] suffixes, String[] ignoreFiles, File directory, FileVisitor fileVisitor) {
        int i;
        File[] files = directory.listFiles(new SuffixAndIgnoreFileFilter(suffixes, ignoreFiles));
        if (files != null) {
            for (i = 0; i < files.length; ++i) {
                File file = files[i];
                fileVisitor.visitFile(file);
            }
        }
        if ((files = directory.listFiles(new DirectoryFileFilter())) != null) {
            for (i = 0; i < files.length; ++i) {
                File childDirectory = files[i];
                this.visitDirectory(suffixes, ignoreFiles, childDirectory, fileVisitor);
            }
        }
    }

    private class DirectoryFileFilter
    implements FileFilter {
        private final String[] ignoreDirectory = new String[]{".svn"};

        private DirectoryFileFilter() {
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            if (pathname.isDirectory()) {
                String relativePathname = pathname.getAbsolutePath();
                if (!(relativePathname = ((Object)Strings.replaceAll(relativePathname, ApacheLicenseHeaderTestCase.this.baseDirectory.getAbsolutePath() + System.getProperty("file.separator"), "")).toString()).equals("target")) {
                    boolean found = false;
                    for (int i = 0; i < this.ignoreDirectory.length; ++i) {
                        String ignore = this.ignoreDirectory[i];
                        if (!pathname.getName().equals(ignore)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        accept = true;
                    }
                }
            }
            return accept;
        }
    }

    private class SuffixAndIgnoreFileFilter
    implements FileFilter {
        private final String[] suffixes;
        private final String[] ignoreFiles;

        private SuffixAndIgnoreFileFilter(String[] suffixes) {
            this(suffixes, null);
        }

        private SuffixAndIgnoreFileFilter(String[] suffixes, String[] ignoreFiles) {
            this.suffixes = suffixes;
            this.ignoreFiles = ignoreFiles;
        }

        public boolean accept(File pathname) {
            boolean accept = false;
            if (pathname.isFile() && !this.ignoreFile(pathname)) {
                for (int i = 0; i < this.suffixes.length; ++i) {
                    String suffix = this.suffixes[i];
                    if (!pathname.getName().endsWith("." + suffix)) continue;
                    accept = true;
                    break;
                }
            }
            return accept;
        }

        private boolean ignoreFile(File pathname) {
            boolean ignore = false;
            if (this.ignoreFiles != null) {
                String relativePathname = pathname.getAbsolutePath();
                relativePathname = ((Object)Strings.replaceAll(relativePathname, ApacheLicenseHeaderTestCase.this.baseDirectory.getAbsolutePath() + System.getProperty("file.separator"), "")).toString();
                for (int i = 0; i < this.ignoreFiles.length; ++i) {
                    String ignorePath = this.ignoreFiles[i];
                    ignorePath = ((Object)Strings.replaceAll(ignorePath, "/", System.getProperty("file.separator"))).toString();
                    File ignoreFile = new File(ApacheLicenseHeaderTestCase.this.baseDirectory, ignorePath);
                    if (ignoreFile.isDirectory() && pathname.getAbsolutePath().startsWith(ignoreFile.getAbsolutePath())) {
                        ignore = true;
                        break;
                    }
                    if (!ignoreFile.isFile() || !relativePathname.equals(ignorePath)) continue;
                    ignore = true;
                    break;
                }
            }
            return ignore;
        }
    }

    static interface FileVisitor {
        public void visitFile(File var1);
    }
}

