/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.value;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.StringValueConversionException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteValueMap
implements IValueMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private IValueMap wrapped;

    public CopyOnWriteValueMap(IValueMap wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public void clear() {
        this.checkAndCopy();
        this.wrapped.clear();
    }

    private void checkAndCopy() {
        if (this.wrapped.isImmutable()) {
            this.wrapped = new ValueMap(this.wrapped);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrapped.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.checkAndCopy();
        return this.wrapped.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.wrapped.equals(o);
    }

    @Override
    public Object get(Object key) {
        return this.wrapped.get(key);
    }

    @Override
    public boolean getBoolean(String key) throws StringValueConversionException {
        return this.wrapped.getBoolean(key);
    }

    @Override
    public CharSequence getCharSequence(String key) {
        return this.wrapped.getCharSequence(key);
    }

    @Override
    public double getDouble(String key) throws StringValueConversionException {
        return this.wrapped.getDouble(key);
    }

    @Override
    public double getDouble(String key, double defaultValue) throws StringValueConversionException {
        return this.wrapped.getDouble(key, defaultValue);
    }

    @Override
    public Duration getDuration(String key) throws StringValueConversionException {
        return this.wrapped.getDuration(key);
    }

    @Override
    public int getInt(String key, int defaultValue) throws StringValueConversionException {
        return this.wrapped.getInt(key, defaultValue);
    }

    @Override
    public int getInt(String key) throws StringValueConversionException {
        return this.wrapped.getInt(key);
    }

    @Override
    public String getKey(String key) {
        return this.wrapped.getKey(key);
    }

    @Override
    public long getLong(String key, long defaultValue) throws StringValueConversionException {
        return this.wrapped.getLong(key, defaultValue);
    }

    @Override
    public long getLong(String key) throws StringValueConversionException {
        return this.wrapped.getLong(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.wrapped.getString(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return this.wrapped.getString(key);
    }

    @Override
    public String[] getStringArray(String key) {
        return this.wrapped.getStringArray(key);
    }

    @Override
    public StringValue getStringValue(String key) {
        return this.wrapped.getStringValue(key);
    }

    @Override
    public Time getTime(String key) throws StringValueConversionException {
        return this.wrapped.getTime(key);
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public Set<String> keySet() {
        this.checkAndCopy();
        return this.wrapped.keySet();
    }

    @Override
    public IValueMap makeImmutable() {
        return this.wrapped.makeImmutable();
    }

    @Override
    public Object put(String key, Object value) {
        this.checkAndCopy();
        return this.wrapped.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.checkAndCopy();
        this.wrapped.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        this.checkAndCopy();
        return this.wrapped.remove(key);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public Collection<Object> values() {
        return this.wrapped.values();
    }

    public String toString() {
        return super.toString();
    }

    @Override
    public Boolean getAsBoolean(String key) {
        return this.wrapped.getAsBoolean(key);
    }

    @Override
    public boolean getAsBoolean(String key, boolean defaultValue) {
        return this.wrapped.getAsBoolean(key, defaultValue);
    }

    @Override
    public Integer getAsInteger(String key) {
        return this.wrapped.getAsInteger(key);
    }

    @Override
    public int getAsInteger(String key, int defaultValue) {
        return this.wrapped.getAsInteger(key, defaultValue);
    }

    @Override
    public Long getAsLong(String key) {
        return this.wrapped.getAsLong(key);
    }

    @Override
    public long getAsLong(String key, long defaultValue) {
        return this.wrapped.getAsLong(key, defaultValue);
    }

    @Override
    public Double getAsDouble(String key) {
        return this.wrapped.getAsDouble(key);
    }

    @Override
    public double getAsDouble(String key, double defaultValue) {
        return this.wrapped.getAsDouble(key, defaultValue);
    }

    @Override
    public Duration getAsDuration(String key) {
        return this.wrapped.getAsDuration(key);
    }

    @Override
    public Duration getAsDuration(String key, Duration defaultValue) {
        return this.wrapped.getAsDuration(key, defaultValue);
    }

    @Override
    public Time getAsTime(String key) {
        return this.wrapped.getAsTime(key);
    }

    @Override
    public Time getAsTime(String key, Time defaultValue) {
        return this.wrapped.getAsTime(key, defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, Class<T> eClass) {
        return (T)this.wrapped.getAsEnum(key, eClass);
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, T defaultValue) {
        return this.wrapped.getAsEnum(key, defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getAsEnum(String key, Class<T> eClass, T defaultValue) {
        return this.wrapped.getAsEnum(key, eClass, defaultValue);
    }
}

