/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.visit;

import org.apache.wicket.util.visit.IVisitFilter;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Visits {
    private Visits() {
    }

    public static final <S, R> R visitChildren(Iterable<?> container, IVisitor<S, R> visitor, IVisitFilter filter) {
        Visit visit = new Visit();
        Visits.visitChildren(container, visitor, filter, visit);
        return visit.getResult();
    }

    private static final <S, R> void visitChildren(Iterable<?> container, IVisitor<S, R> visitor, IVisitFilter filter, Visit<R> visit) {
        if (visitor == null) {
            throw new IllegalArgumentException("argument visitor may not be null");
        }
        for (Object child : container) {
            if (filter.visitObject(child)) {
                Visit childTraversal = new Visit();
                Object s = child;
                visitor.component(s, childTraversal);
                if (childTraversal.isStopped()) {
                    visit.stop(childTraversal.getResult());
                    return;
                }
                if (childTraversal.isDontGoDeeper()) continue;
            }
            if (visit.isDontGoDeeper() || !(child instanceof Iterable) || !filter.visitChildren(child)) continue;
            Visits.visitChildren((Iterable)child, visitor, filter, visit);
            if (!visit.isStopped()) continue;
            return;
        }
    }

    public static final <S, R> R visitChildren(Iterable<?> container, IVisitor<S, R> visitor) {
        return Visits.visitChildren(container, visitor, IVisitFilter.ANY);
    }

    public static final <S, R> R visitComponentsPostOrder(S root, IVisitor<S, R> visitor) {
        return Visits.visitComponentsPostOrder(root, visitor, IVisitFilter.ANY);
    }

    public static final <S, R> R visitComponentsPostOrder(Object root, IVisitor<S, R> visitor, IVisitFilter filter) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument `visitor` cannot be null");
        }
        Visit visit = new Visit();
        Visits.visitComponentsPostOrderHelper(root, visitor, filter, visit);
        return visit.getResult();
    }

    private static final <S, R> void visitComponentsPostOrderHelper(Object component, IVisitor<S, R> visitor, IVisitFilter filter, Visit<R> visit) {
        if (component instanceof Iterable) {
            Iterable container = (Iterable)component;
            if (filter.visitChildren(container)) {
                Visit childTraversal = new Visit();
                for (Object child : (Iterable)component) {
                    if (!(child instanceof Iterable)) continue;
                    Visits.visitComponentsPostOrderHelper(child, visitor, filter, childTraversal);
                    if (!childTraversal.isStopped()) continue;
                    visit.stop(childTraversal.getResult());
                    return;
                }
            }
            if (filter.visitObject(component)) {
                visitor.component(component, visit);
            }
        }
    }
}

