/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.osgi;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.wink.osgi.WinkRequestProcessor;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(JaxRsFilter.class);
    private WinkRequestProcessor winkProvider;

    private boolean accepts(HttpServletRequest request) {
        DeploymentConfiguration deploymentConfiguration = this.winkProvider.getRequestProcessor().getConfiguration();
        ResourceRegistry resourceRegistry = deploymentConfiguration.getResourceRegistry();
        return resourceRegistry.getMatchingRootResources(request.getRequestURI()).size() > 0;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && this.accepts((HttpServletRequest)request)) {
            log.debug("processing request");
            this.winkProvider.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    protected void bindWinkProvider(WinkRequestProcessor winkRequestProcessor) {
        this.winkProvider = winkRequestProcessor;
    }

    protected void unbindWinkProvider(WinkRequestProcessor winkRequestProcessor) {
        if (this.winkProvider == winkRequestProcessor) {
            this.winkProvider = null;
        }
    }
}

