/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.osgi;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.runtime.RuntimeDelegateImpl;
import org.apache.wink.osgi.internal.DummyRuntimeDelegate;
import org.apache.wink.osgi.internal.ThreadRootResourceDeploymentConfiguration;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.RequestProcessor;
import org.apache.wink.server.utils.RegistrationUtils;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinkRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(WinkRequestProcessor.class);
    private RequestProcessor requestProcessor;
    private Set<Object> components = new HashSet<Object>();
    private Set<Class> componentClasses = new HashSet<Class>();
    private boolean requestProcessorOutdated = false;

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.ensureNotOutdated();
        this.requestProcessor.handleRequest(request, response);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object resource) throws ServletException {
        this.ensureNotOutdated();
        ThreadRootResourceDeploymentConfiguration.threadLocalRootResource.set(resource);
        this.requestProcessor.handleRequest(request, response);
        ThreadRootResourceDeploymentConfiguration.threadLocalRootResource.remove();
    }

    protected void activate(ComponentContext context) {
        RuntimeDelegate.setInstance(new DummyRuntimeDelegate());
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        this.init();
    }

    protected void deactivate(ComponentContext context) {
        this.components.clear();
        this.requestProcessor = null;
        this.requestProcessorOutdated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindComponent(Object component) {
        if (this.requestProcessor != null) {
            this.ensureNotOutdated();
            this.registerComponent(component);
        }
        WinkRequestProcessor winkRequestProcessor = this;
        synchronized (winkRequestProcessor) {
            this.components.add(component);
        }
    }

    public synchronized void unbindComponent(Object component) {
        this.components.remove(component);
        this.requestProcessorOutdated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindComponentClass(Class componentClass) {
        this.ensureNotOutdated();
        this.registerComponentClass(componentClass);
        WinkRequestProcessor winkRequestProcessor = this;
        synchronized (winkRequestProcessor) {
            this.componentClasses.add(componentClass);
        }
    }

    public synchronized void unbindComponentClass(Class componentClass) {
        this.componentClasses.remove(componentClass);
        this.requestProcessorOutdated = true;
    }

    RequestProcessor getRequestProcessor() {
        this.ensureNotOutdated();
        return this.requestProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNotOutdated() {
        if (this.requestProcessorOutdated) {
            WinkRequestProcessor winkRequestProcessor = this;
            synchronized (winkRequestProcessor) {
                if (this.requestProcessorOutdated) {
                    this.init();
                    this.requestProcessorOutdated = false;
                }
            }
        }
    }

    private void init() {
        ThreadRootResourceDeploymentConfiguration configuration = new ThreadRootResourceDeploymentConfiguration();
        configuration.init();
        configuration.getProperties().setProperty("wink.rootResource", "none");
        this.requestProcessor = new RequestProcessor((DeploymentConfiguration)configuration);
        for (Object component : this.components) {
            this.registerComponent(component);
        }
        for (Class componentClass : this.componentClasses) {
            this.registerComponentClass(componentClass);
        }
    }

    private void registerComponent(Object component) {
        RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(new Object[]{component});
        this.requestProcessor.getConfiguration().addApplication((Application)application, false);
    }

    private void registerComponentClass(Class componentClass) {
        RegistrationUtils.InnerApplication application = new RegistrationUtils.InnerApplication(new Class[]{componentClass});
        this.requestProcessor.getConfiguration().addApplication((Application)application, false);
    }
}

