/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.osgi.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.ResourceMetadataCollector;
import org.apache.wink.common.internal.uritemplate.UriTemplateMatcher;
import org.apache.wink.common.internal.uritemplate.UriTemplateProcessor;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.registry.MethodRecord;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.apache.wink.server.internal.registry.SubResourceInstance;

public class ThreadRootResourceDeploymentConfiguration
extends DeploymentConfiguration {
    public static ThreadLocal<Object> threadLocalRootResource = new ThreadLocal();

    private ResourceInstance getThreadLocalResourceInstance() {
        final Object rootResource = threadLocalRootResource.get();
        if (rootResource == null) {
            return null;
        }
        ObjectFactory<Object> objectFactory = new ObjectFactory<Object>(){

            public Object getInstance(RuntimeContext context) {
                return rootResource;
            }

            public Class<Object> getInstanceClass() {
                return Object.class;
            }

            public void releaseInstance(Object instance, RuntimeContext context) {
            }

            public void releaseAll(RuntimeContext context) {
            }
        };
        ClassMetadata metadata = ResourceMetadataCollector.collectMetadata(rootResource.getClass());
        UriTemplateProcessor processor = new UriTemplateProcessor(){

            public void compile(String arg0) {
                this.pattern = Pattern.compile(".*");
            }
        };
        processor.compile("{.*}");
        UriTemplateMatcher uriTemplateMatcher = processor.matcher();
        uriTemplateMatcher.match("foo");
        return new ResourceInstance(rootResource, new ResourceRecord(metadata, (ObjectFactory)objectFactory, processor), uriTemplateMatcher);
    }

    public ResourceRegistry getResourceRegistry() {
        return new FixedResourceRegistry(super.getResourceRegistry());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FixedResourceRegistry
    extends ResourceRegistry {
        private ResourceRegistry wrapped;

        public FixedResourceRegistry(ResourceRegistry wrapped) {
            super(new LifecycleManagersRegistry(), null);
            this.wrapped = wrapped;
        }

        public void addResource(Class<?> arg0, double arg1) {
            this.wrapped.addResource(arg0, arg1);
        }

        public void addResource(Class<?> clazz) {
            this.wrapped.addResource(clazz);
        }

        public void addResource(Object arg0, double arg1) {
            this.wrapped.addResource(arg0, arg1);
        }

        public void addResource(Object instance) {
            this.wrapped.addResource(instance);
        }

        public MethodRecord findMethod(ResourceInstance arg0, RuntimeContext arg1) throws WebApplicationException {
            return this.wrapped.findMethod(arg0, arg1);
        }

        public SubResourceInstance findSubResourceMethod(String pattern, List<SubResourceInstance> subResourceRecords, ResourceInstance resource, RuntimeContext context) throws WebApplicationException {
            return this.wrapped.findSubResourceMethod(pattern, subResourceRecords, resource, context);
        }

        public List<ResourceInstance> getMatchingRootResources(String arg0, boolean arg1) {
            ResourceInstance threadLocaleInstance = ThreadRootResourceDeploymentConfiguration.this.getThreadLocalResourceInstance();
            if (threadLocaleInstance == null) {
                return this.wrapped.getMatchingRootResources(arg0, arg1);
            }
            return Collections.singletonList(threadLocaleInstance);
        }

        public List<ResourceInstance> getMatchingRootResources(String uri) {
            return this.wrapped.getMatchingRootResources(uri);
        }

        public Set<String> getOptions(ResourceInstance arg0) {
            return this.wrapped.getOptions(arg0);
        }

        public ResourceRecord getRecord(Class<?> clazz) {
            return this.wrapped.getRecord(clazz);
        }

        public ResourceRecord getRecord(Object instance, boolean isRootResource) {
            return this.wrapped.getRecord(instance, isRootResource);
        }

        public ResourceRecord getRecord(Object instance) {
            return this.wrapped.getRecord(instance);
        }

        public List<ResourceRecord> getRecords() {
            return this.wrapped.getRecords();
        }

        public void removeAllResources() {
            this.wrapped.removeAllResources();
        }
    }
}

