/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.xbean.kernel.Kernel;
import org.apache.xbean.kernel.KernelAlreadyExistsException;
import org.apache.xbean.kernel.KernelFactoryError;
import org.apache.xbean.kernel.standard.StandardKernelFactory;

public abstract class KernelFactory {
    public static final String KERNEL_FACTORY_KEY = (class$org$apache$xbean$kernel$KernelFactory == null ? (class$org$apache$xbean$kernel$KernelFactory = KernelFactory.class$("org.apache.xbean.kernel.KernelFactory")) : class$org$apache$xbean$kernel$KernelFactory).getName();
    private static final ConcurrentHashMap kernels = new ConcurrentHashMap(1);
    static /* synthetic */ Class class$org$apache$xbean$kernel$KernelFactory;

    public static Kernel getKernel(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        return (Kernel)kernels.get((Object)name);
    }

    public static Map getKernels() {
        return new HashMap(kernels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KernelFactory newInstance() throws KernelFactoryError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = (class$org$apache$xbean$kernel$KernelFactory == null ? (class$org$apache$xbean$kernel$KernelFactory = KernelFactory.class$("org.apache.xbean.kernel.KernelFactory")) : class$org$apache$xbean$kernel$KernelFactory).getClassLoader();
        }
        try {
            String kernelFactoryName = System.getProperty(KERNEL_FACTORY_KEY);
            if (kernelFactoryName != null) {
                return KernelFactory.createKernelFactory(kernelFactoryName, classLoader);
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + KERNEL_FACTORY_KEY;
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(serviceId);
            if (inputStream != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String kernelFactoryName = reader.readLine();
                reader.close();
                if (kernelFactoryName != null && kernelFactoryName.length() > 0) {
                    KernelFactory kernelFactory = KernelFactory.createKernelFactory(kernelFactoryName, classLoader);
                    return kernelFactory;
                }
            }
        }
        catch (Exception ignored) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {}
                inputStream = null;
            }
        }
        return new StandardKernelFactory();
    }

    public static void destroyInstance(Kernel kernel) throws KernelFactoryError {
        if (kernel.isRunning()) {
            throw new KernelFactoryError("Kernel is running: name" + kernel.getKernelName());
        }
        kernels.remove((Object)kernel.getKernelName(), (Object)kernel);
    }

    private static KernelFactory createKernelFactory(String className, ClassLoader classLoader) throws KernelFactoryError {
        try {
            return (KernelFactory)classLoader.loadClass(className).newInstance();
        }
        catch (ClassCastException e) {
            throw new KernelFactoryError("Kernel factory class does not implement KernelFactory: " + className);
        }
        catch (ClassNotFoundException e) {
            throw new KernelFactoryError("Kernel factory class not found: " + className);
        }
        catch (Exception e) {
            throw new KernelFactoryError("Unable to instantiate kernel factory class: " + className, e);
        }
    }

    public final Kernel createKernel(String name) throws KernelAlreadyExistsException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (kernels.containsKey((Object)name)) {
            throw new KernelAlreadyExistsException(name);
        }
        Kernel kernel = this.createKernelInternal(name);
        if (kernels.putIfAbsent((Object)name, (Object)kernel) != null) {
            throw new KernelAlreadyExistsException(name);
        }
        return kernel;
    }

    protected abstract Kernel createKernelInternal(String var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

