/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.kernel;

import org.apache.xbean.kernel.NullServiceMonitor;
import org.apache.xbean.kernel.ServiceCondition;
import org.apache.xbean.kernel.ServiceConditionContext;
import org.apache.xbean.kernel.ServiceEvent;
import org.apache.xbean.kernel.ServiceName;
import org.apache.xbean.kernel.ServiceNotFoundException;
import org.apache.xbean.kernel.ServiceState;

public class StoppedServiceCondition
implements ServiceCondition {
    private final ServiceName dependency;
    private final DependencyServiceMonitor serviceMonitor = new DependencyServiceMonitor();
    private ServiceConditionContext context;
    private boolean satisfied = true;

    public StoppedServiceCondition(ServiceName dependency) {
        if (dependency == null) {
            throw new NullPointerException("dependency is null");
        }
        this.dependency = dependency;
    }

    public synchronized void initialize(ServiceConditionContext context) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (this.context != null) {
            this.destroy();
        }
        this.context = context;
        this.satisfied = false;
        context.getKernel().addServiceMonitor(this.serviceMonitor, this.dependency);
    }

    public synchronized boolean isSatisfied() {
        if (this.context == null) {
            return true;
        }
        if (!this.satisfied) {
            try {
                if (this.context.getKernel().getService(this.dependency) == ServiceState.RUNNING) {
                    this.satisfied = true;
                    this.context.getKernel().removeServiceMonitor(this.serviceMonitor);
                }
            }
            catch (ServiceNotFoundException serviceNotFoundException) {
                // empty catch block
            }
        }
        return this.satisfied;
    }

    public synchronized void destroy() {
        if (this.context == null) {
            return;
        }
        this.context.getKernel().removeServiceMonitor(this.serviceMonitor);
        this.context = null;
        this.satisfied = true;
    }

    private class DependencyServiceMonitor
    extends NullServiceMonitor {
        private DependencyServiceMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceStopped(ServiceEvent serviceEvent) {
            StoppedServiceCondition stoppedServiceCondition = StoppedServiceCondition.this;
            synchronized (stoppedServiceCondition) {
                if (StoppedServiceCondition.this.context != null) {
                    return;
                }
                if (!StoppedServiceCondition.this.satisfied) {
                    return;
                }
                if (StoppedServiceCondition.this.isSatisfied()) {
                    StoppedServiceCondition.this.context.setSatisfied();
                }
            }
        }
    }
}

