/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.server.spring.configuration;

import java.net.URL;
import java.util.ArrayList;
import java.util.ListIterator;
import org.apache.xbean.classloader.JarFileClassLoader;
import org.apache.xbean.server.repository.Repository;
import org.apache.xbean.server.spring.loader.SpringLoader;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.SpringXmlPreprocessor;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClassLoaderXmlPreprocessor
implements SpringXmlPreprocessor {
    private final Repository repository;

    public ClassLoaderXmlPreprocessor(Repository repository) {
        this.repository = repository;
    }

    public void preprocess(SpringApplicationContext applicationContext, XmlBeanDefinitionReader reader, Document document) {
        ClassLoader classLoader;
        NodeList classpathElements = document.getDocumentElement().getElementsByTagName("classpath");
        if (classpathElements.getLength() < 1) {
            classLoader = ClassLoaderXmlPreprocessor.getClassLoader(applicationContext);
        } else {
            String location;
            if (classpathElements.getLength() > 1) {
                throw new FatalBeanException("Expected only classpath element but found " + classpathElements.getLength());
            }
            Element classpathElement = (Element)classpathElements.item(0);
            boolean inverse = false;
            String inverseAttr = classpathElement.getAttribute("inverse");
            if (inverseAttr != null && "true".equalsIgnoreCase(inverseAttr)) {
                inverse = true;
            }
            ArrayList<String> hidden = new ArrayList<String>();
            NodeList hiddenElems = classpathElement.getElementsByTagName("hidden");
            for (int i = 0; i < hiddenElems.getLength(); ++i) {
                Element hiddenElement = (Element)hiddenElems.item(i);
                String pattern = ((Text)hiddenElement.getFirstChild()).getData().trim();
                hidden.add(pattern);
            }
            ArrayList<String> nonOverridable = new ArrayList<String>();
            NodeList nonOverridableElems = classpathElement.getElementsByTagName("nonOverridable");
            for (int i = 0; i < nonOverridableElems.getLength(); ++i) {
                Element nonOverridableElement = (Element)nonOverridableElems.item(i);
                String pattern = ((Text)nonOverridableElement.getFirstChild()).getData().trim();
                nonOverridable.add(pattern);
            }
            ArrayList<String> classpath = new ArrayList<String>();
            NodeList locations = classpathElement.getElementsByTagName("location");
            for (int i = 0; i < locations.getLength(); ++i) {
                Element locationElement = (Element)locations.item(i);
                location = ((Text)locationElement.getFirstChild()).getData().trim();
                classpath.add(location);
            }
            URL[] urls = new URL[classpath.size()];
            ListIterator iterator = classpath.listIterator();
            while (iterator.hasNext()) {
                location = (String)iterator.next();
                URL url = this.repository.getResource(location);
                if (url == null) {
                    throw new FatalBeanException("Unable to resolve classpath location " + location);
                }
                urls[iterator.previousIndex()] = url;
            }
            ClassLoader parentLoader = ClassLoaderXmlPreprocessor.getClassLoader(applicationContext);
            classLoader = new JarFileClassLoader(applicationContext.getDisplayName(), urls, parentLoader, inverse, hidden.toArray(new String[hidden.size()]), nonOverridable.toArray(new String[nonOverridable.size()]));
            document.getDocumentElement().removeChild(classpathElement);
        }
        reader.setBeanClassLoader(classLoader);
        applicationContext.setClassLoader(classLoader);
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private static ClassLoader getClassLoader(SpringApplicationContext applicationContext) {
        ClassLoader classLoader = applicationContext.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = SpringLoader.class.getClassLoader();
        }
        return classLoader;
    }
}

