/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFontReader;
import org.apache.fop.afp.fonts.CharacterSetOrientation;
import org.apache.fop.afp.util.ResourceAccessor;
import org.apache.fop.afp.util.SimpleResourceAccessor;
import org.apache.fop.afp.util.StringUtils;

public class CharacterSet {
    protected static final Log log = LogFactory.getLog((String)CharacterSet.class.getName());
    public static final String DEFAULT_CODEPAGE = "T1V10500";
    public static final String DEFAULT_ENCODING = "Cp500";
    private static final int MAX_NAME_LEN = 8;
    protected String codePage;
    protected String encoding;
    private CharsetEncoder encoder;
    protected String name;
    private ResourceAccessor accessor;
    private boolean isMetricsLoaded = false;
    private final String currentOrientation = "0";
    private Map characterSetOrientations = null;

    public CharacterSet(String codePage, String encoding, String name, String path) {
        this(codePage, encoding, name, new SimpleResourceAccessor(path != null ? new File(path) : null));
    }

    public CharacterSet(String codePage, String encoding, String name, ResourceAccessor accessor) {
        if (name.length() > 8) {
            String msg = "Character set name '" + name + "' must be a maximum of " + 8 + " characters";
            log.error((Object)("Constructor:: " + msg));
            throw new IllegalArgumentException(msg);
        }
        this.name = name.length() < 8 ? StringUtils.rpad(name, ' ', 8) : name;
        this.codePage = codePage;
        this.encoding = encoding;
        try {
            this.encoder = Charset.forName(encoding).newEncoder();
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        catch (UnsupportedCharsetException uce) {
            this.encoder = null;
        }
        this.accessor = accessor;
        this.characterSetOrientations = new HashMap(4);
    }

    public void addCharacterSetOrientation(CharacterSetOrientation cso) {
        this.characterSetOrientations.put(String.valueOf(cso.getOrientation()), cso);
    }

    public int getAscender() {
        this.load();
        return this.getCharacterSetOrientation().getAscender();
    }

    public int getCapHeight() {
        this.load();
        return this.getCharacterSetOrientation().getCapHeight();
    }

    public int getDescender() {
        this.load();
        return this.getCharacterSetOrientation().getDescender();
    }

    public int getFirstChar() {
        this.load();
        return this.getCharacterSetOrientation().getFirstChar();
    }

    public int getLastChar() {
        this.load();
        return this.getCharacterSetOrientation().getLastChar();
    }

    public ResourceAccessor getResourceAccessor() {
        return this.accessor;
    }

    public int[] getWidths() {
        this.load();
        return this.getCharacterSetOrientation().getWidths();
    }

    public int getXHeight() {
        this.load();
        return this.getCharacterSetOrientation().getXHeight();
    }

    public int getWidth(int character) {
        this.load();
        return this.getCharacterSetOrientation().getWidth(character);
    }

    private void load() {
        if (!this.isMetricsLoaded) {
            AFPFontReader afpFontReader = new AFPFontReader();
            try {
                afpFontReader.loadCharacterSetMetric(this);
                this.isMetricsLoaded = true;
            }
            catch (IOException e) {
                String msg = "Failed to load the character set metrics for code page " + this.codePage;
                log.error((Object)msg);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public byte[] getNameBytes() {
        byte[] nameBytes = null;
        try {
            nameBytes = this.name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            nameBytes = this.name.getBytes();
            log.warn((Object)("UnsupportedEncodingException translating the name " + this.name));
        }
        return nameBytes;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public String getEncoding() {
        return this.encoding;
    }

    private CharacterSetOrientation getCharacterSetOrientation() {
        CharacterSetOrientation c = (CharacterSetOrientation)this.characterSetOrientations.get("0");
        return c;
    }

    public boolean hasChar(char c) {
        if (this.encoder != null) {
            return this.encoder.canEncode(c);
        }
        return true;
    }

    public byte[] encodeChars(CharSequence chars) throws CharacterCodingException {
        if (this.encoder != null) {
            ByteBuffer bb = this.encoder.encode(CharBuffer.wrap(chars));
            if (bb.hasArray()) {
                return bb.array();
            }
            bb.rewind();
            byte[] bytes = new byte[bb.remaining()];
            bb.get(bytes);
            return bytes;
        }
        try {
            byte[] bytes = ((Object)chars).toString().getBytes(this.encoding);
            return bytes;
        }
        catch (UnsupportedEncodingException uee) {
            throw new UnsupportedOperationException("Unsupported encoding: " + uee.getMessage());
        }
    }

    public char mapChar(char c) {
        return c;
    }
}

