/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.ioca;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.afp.ioca.ImageSizeParameter;
import org.apache.fop.afp.modca.AbstractStructuredObject;

public class ImageContent
extends AbstractStructuredObject {
    public static final byte COMPID_G3_MH = -128;
    public static final byte COMPID_G3_MR = -127;
    public static final byte COMPID_G3_MMR = -126;
    private ImageSizeParameter imageSizeParameter = null;
    private byte encoding = (byte)3;
    private byte size = 1;
    private byte compression = (byte)-64;
    private byte colorModel = 1;
    private boolean subtractive = false;
    private byte[] data;
    private static final int MAX_DATA_LEN = 65535;

    public void setImageSizeParameter(ImageSizeParameter imageSizeParameter) {
        this.imageSizeParameter = imageSizeParameter;
    }

    public void setImageEncoding(byte enc) {
        this.encoding = enc;
    }

    public void setImageCompression(byte comp) {
        this.compression = comp;
    }

    public void setImageIDESize(byte s) {
        this.size = s;
    }

    public void setImageIDEColorModel(byte color) {
        this.colorModel = color;
    }

    public void setSubtractive(boolean subtractive) {
        this.subtractive = subtractive;
    }

    public void setImageData(byte[] imageData) {
        this.data = imageData;
    }

    protected void writeContent(OutputStream os) throws IOException {
        boolean useFS10;
        if (this.imageSizeParameter != null) {
            this.imageSizeParameter.writeToStream(os);
        }
        os.write(this.getImageEncodingParameter());
        os.write(this.getImageIDESizeParameter());
        boolean bl = useFS10 = this.size == 1;
        if (!useFS10) {
            os.write(this.getIDEStructureParameter());
            os.write(this.getExternalAlgorithmParameter());
        }
        byte[] dataHeader = new byte[]{-2, -110, 0, 0};
        int lengthOffset = 2;
        if (this.data != null) {
            ImageContent.writeChunksToStream(this.data, dataHeader, 2, 65535, os);
        }
    }

    protected void writeStart(OutputStream os) throws IOException {
        byte[] startData = new byte[]{-111, 1, -1};
        os.write(startData);
    }

    protected void writeEnd(OutputStream os) throws IOException {
        byte[] endData = new byte[]{-109, 0};
        os.write(endData);
    }

    private byte[] getImageEncodingParameter() {
        byte[] encodingData = new byte[]{-107, 2, this.encoding, 1};
        return encodingData;
    }

    private byte[] getExternalAlgorithmParameter() {
        if (this.encoding == -125 && this.compression != 0) {
            byte[] extAlgData = new byte[]{-107, 0, 16, 0, -125, 0, 0, 0, this.compression, 0, 0, 0};
            extAlgData[1] = (byte)(extAlgData.length - 2);
            return extAlgData;
        }
        return new byte[0];
    }

    private byte[] getImageIDESizeParameter() {
        if (this.size != 1) {
            byte[] ideSizeData = new byte[]{-106, 1, this.size};
            return ideSizeData;
        }
        return new byte[0];
    }

    private byte[] getIDEStructureParameter() {
        byte flags = 0;
        if (this.subtractive) {
            flags = (byte)(flags | 0x80);
        }
        if (this.colorModel != 0 && this.size == 24) {
            byte bits = (byte)(this.size / 3);
            byte[] ideStructData = new byte[]{-101, 0, flags, this.colorModel, 0, 0, 0, bits, bits, bits};
            ideStructData[1] = (byte)(ideStructData.length - 2);
            return ideStructData;
        }
        if (this.size == 1) {
            byte[] ideStructData = new byte[]{-101, 0, flags, this.colorModel, 0, 0, 0, 1};
            ideStructData[1] = (byte)(ideStructData.length - 2);
            return ideStructData;
        }
        return new byte[0];
    }
}

