/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.fop.util.ConversionUtils;
import org.apache.fop.util.XMLConstants;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLUtil
implements XMLConstants {
    public static boolean getAttributeAsBoolean(Attributes attributes, String name, boolean defaultValue) {
        String s = attributes.getValue(name);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static int getAttributeAsInt(Attributes attributes, String name, int defaultValue) {
        String s = attributes.getValue(name);
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static int getAttributeAsInt(Attributes attributes, String name) throws SAXException {
        String s = attributes.getValue(name);
        if (s == null) {
            throw new SAXException("Attribute '" + name + "' is missing");
        }
        return Integer.parseInt(s);
    }

    public static Integer getAttributeAsInteger(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        return new Integer(s);
    }

    public static Rectangle2D getAttributeAsRectangle2D(Attributes attributes, String name) {
        String s = attributes.getValue(name).trim();
        double[] values = ConversionUtils.toDoubleArray(s, "\\s");
        if (values.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 double values!");
        }
        return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
    }

    public static Rectangle getAttributeAsRectangle(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        int[] values = ConversionUtils.toIntArray(s.trim(), "\\s");
        if (values.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 int values!");
        }
        return new Rectangle(values[0], values[1], values[2], values[3]);
    }

    public static int[] getAttributeAsIntArray(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        return ConversionUtils.toIntArray(s.trim(), "\\s");
    }

    public static void addAttribute(AttributesImpl atts, QName attribute, String value) {
        atts.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQName(), "CDATA", value);
    }

    public static void addAttribute(AttributesImpl atts, String localName, String value) {
        atts.addAttribute("", localName, localName, "CDATA", value);
    }
}

