/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.sap.universe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.completer.CachedCompleter;
import org.apache.zeppelin.completer.CompletionType;
import org.apache.zeppelin.completer.StringsCompleter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.sap.universe.UniverseClient;
import org.apache.zeppelin.sap.universe.UniverseNodeInfo;
import org.apache.zeppelin.sap.universe.UniverseNodeInfoCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniverseCompleter {
    private static Logger logger = LoggerFactory.getLogger(UniverseCompleter.class);
    private static final String KEYWORD_SPLITERATOR = ",";
    public static final String CLEAN_NAME_REGEX = "\\[|\\]";
    public static final Character START_NAME = Character.valueOf('[');
    public static final Character END_NAME = Character.valueOf(']');
    public static final String KW_UNIVERSE = "universe";
    public static final String TYPE_FOLDER = "folder";
    private static final Comparator nodeInfoComparator = new Comparator<UniverseNodeInfo>(){

        @Override
        public int compare(UniverseNodeInfo o1, UniverseNodeInfo o2) {
            if (o1.getType().equalsIgnoreCase(UniverseCompleter.TYPE_FOLDER) && o2.getType().equalsIgnoreCase(UniverseCompleter.TYPE_FOLDER)) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
            if (o1.getType().equalsIgnoreCase(UniverseCompleter.TYPE_FOLDER)) {
                return -1;
            }
            if (o2.getType().equalsIgnoreCase(UniverseCompleter.TYPE_FOLDER)) {
                return 1;
            }
            if (!o1.getType().equalsIgnoreCase(o2.getType())) {
                return o1.getType().compareToIgnoreCase(o2.getType());
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private ArgumentCompleter.WhitespaceArgumentDelimiter sqlDelimiter = new ArgumentCompleter.WhitespaceArgumentDelimiter(){
        private Pattern pattern = Pattern.compile(",|;");

        public boolean isDelimiterChar(CharSequence buffer, int pos) {
            char ch;
            char c = buffer.charAt(pos);
            boolean endName = false;
            for (int i = pos; i > 0 && (ch = buffer.charAt(i)) != '\n'; --i) {
                if (ch == START_NAME.charValue() && !endName) {
                    return false;
                }
                if (ch == END_NAME.charValue()) break;
            }
            return this.pattern.matcher("" + buffer.charAt(pos)).matches() || super.isDelimiterChar(buffer, pos);
        }
    };
    private CachedCompleter universeCompleter;
    private CachedCompleter keywordCompleter;
    private Map<String, CachedCompleter> universeInfoCompletersMap = new HashMap<String, CachedCompleter>();
    private int ttlInSeconds;

    public UniverseCompleter(int ttlInSeconds) {
        this.ttlInSeconds = ttlInSeconds;
    }

    public int complete(String buffer, int cursor, List<InterpreterCompletion> candidates) {
        CursorArgument cursorArgument = this.parseCursorArgument(buffer, cursor);
        String argument = cursorArgument.getCursorArgumentPartForComplete();
        if (cursorArgument.isUniverseNamePosition()) {
            ArrayList<CharSequence> universeCandidates = new ArrayList<CharSequence>();
            this.universeCompleter.getCompleter().complete(argument, argument.length(), universeCandidates);
            this.addCompletions(candidates, universeCandidates, CompletionType.universe.name());
            return universeCandidates.size();
        }
        if (cursorArgument.isUniverseNodePosition()) {
            ArrayList<UniverseNodeInfo> universeNodeCandidates = new ArrayList<UniverseNodeInfo>();
            CachedCompleter completer = this.universeInfoCompletersMap.get(cursorArgument.getUniverse());
            if (completer != null) {
                completer.getCompleter().complete(argument, argument.length(), universeNodeCandidates);
            }
            Collections.sort(universeNodeCandidates, nodeInfoComparator);
            this.addCompletions(candidates, universeNodeCandidates);
            return universeNodeCandidates.size();
        }
        ArrayList<CharSequence> keywordCandidates = new ArrayList<CharSequence>();
        this.keywordCompleter.getCompleter().complete(argument, argument.length() > 0 ? argument.length() : 0, keywordCandidates);
        this.addCompletions(candidates, keywordCandidates, CompletionType.keyword.name());
        return keywordCandidates.size();
    }

    public void createOrUpdate(UniverseClient client, String token, String buffer, int cursor) {
        try {
            Set<String> keywords;
            CursorArgument cursorArgument = this.parseCursorArgument(buffer, cursor);
            if ((this.keywordCompleter == null || this.keywordCompleter.getCompleter() == null || this.keywordCompleter.isExpired()) && (keywords = this.getKeywordsCompletions()) != null && !keywords.isEmpty()) {
                this.keywordCompleter = new CachedCompleter((Completer)new StringsCompleter(keywords), 0);
            }
            if (cursorArgument.needLoadUniverses() || this.universeCompleter == null || this.universeCompleter.getCompleter() == null || this.universeCompleter.isExpired()) {
                client.cleanUniverses();
                client.loadUniverses(token);
                if (client.getUniversesMap().size() > 0) {
                    this.universeCompleter = new CachedCompleter((Completer)new StringsCompleter(client.getUniversesMap().keySet()), this.ttlInSeconds);
                }
            }
            if (cursorArgument.needLoadUniverseInfo() && (!this.universeInfoCompletersMap.containsKey(cursorArgument.getUniverse()) || this.universeInfoCompletersMap.get(cursorArgument.getUniverse()).getCompleter() == null || this.universeInfoCompletersMap.get(cursorArgument.getUniverse()).isExpired()) && StringUtils.isNotBlank((CharSequence)cursorArgument.getUniverse())) {
                client.removeUniverseInfo(cursorArgument.getUniverse());
                Map<String, UniverseNodeInfo> info = client.getUniverseNodesInfo(token, cursorArgument.getUniverse());
                CachedCompleter completer = new CachedCompleter((Completer)new UniverseNodeInfoCompleter(info.values()), this.ttlInSeconds);
                this.universeInfoCompletersMap.put(cursorArgument.getUniverse(), completer);
            }
        }
        catch (Exception e) {
            logger.error("Failed to update completions", (Throwable)e);
        }
    }

    private Set<String> getKeywordsCompletions() throws IOException {
        String keywords = new BufferedReader(new InputStreamReader(UniverseCompleter.class.getResourceAsStream("/universe.keywords"))).readLine();
        TreeSet<String> completions = new TreeSet<String>();
        if (StringUtils.isNotBlank((CharSequence)keywords)) {
            String[] words;
            for (String word : words = keywords.split(KEYWORD_SPLITERATOR)) {
                completions.add(word);
            }
        }
        return completions;
    }

    private CursorArgument parseCursorArgument(String buffer, int cursor) {
        String buf;
        CursorArgument result = new CursorArgument();
        if (buffer != null && buffer.length() >= cursor && StringUtils.isNotBlank((CharSequence)(buf = buffer.substring(0, cursor)))) {
            ArgumentCompleter.ArgumentList argList = this.sqlDelimiter.delimit((CharSequence)buf, cursor);
            int argIndex = argList.getCursorArgumentIndex();
            if (argIndex == 0) {
                result.setCursorArgumentPartForComplete(argList.getCursorArgument());
                return result;
            }
            if (argIndex > 0 && argList.getArguments()[argIndex - 1].equalsIgnoreCase(KW_UNIVERSE)) {
                result.setUniverseNamePosition(true);
                result.setCursorArgumentPartForComplete(this.cleanName(argList.getCursorArgument().substring(0, argList.getArgumentPosition())));
                return result;
            }
            if (argIndex > 1) {
                for (int i = argIndex - 2; i >= 0; --i) {
                    if (!argList.getArguments()[i].equalsIgnoreCase(KW_UNIVERSE)) continue;
                    result.setUniverse(this.cleanName(argList.getArguments()[i + 1]));
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)result.getUniverse()) && argList.getCursorArgument().startsWith(START_NAME.toString())) {
                    result.setCursorArgumentPartForComplete(argList.getCursorArgument().substring(0, argList.getArgumentPosition()));
                    result.setUniverseNodePosition(true);
                    return result;
                }
                result.setCursorArgumentPartForComplete(argList.getCursorArgument().substring(0, argList.getArgumentPosition()));
            }
        }
        if (result.getCursorArgumentPartForComplete() == null) {
            result.setCursorArgumentPartForComplete("");
        }
        return result;
    }

    private String cleanName(String name) {
        return name.replaceAll(CLEAN_NAME_REGEX, "");
    }

    private void addCompletions(List<InterpreterCompletion> interpreterCompletions, List<CharSequence> candidates, String meta) {
        for (CharSequence candidate : candidates) {
            String value = meta.equalsIgnoreCase(CompletionType.universe.name()) ? String.format("%s%s;\n", candidate.toString(), END_NAME) : candidate.toString();
            interpreterCompletions.add(new InterpreterCompletion(candidate.toString(), value, meta));
        }
    }

    private void addCompletions(List<InterpreterCompletion> interpreterCompletions, List<UniverseNodeInfo> candidates) {
        for (UniverseNodeInfo candidate : candidates) {
            String value = candidate.getType().equalsIgnoreCase(TYPE_FOLDER) ? String.format("%s%s.%s", candidate.getName(), END_NAME, START_NAME) : String.format("%s%s", candidate.getName(), END_NAME);
            interpreterCompletions.add(new InterpreterCompletion(candidate.getName(), value, candidate.getType()));
        }
    }

    public CachedCompleter getUniverseCompleter() {
        return this.universeCompleter;
    }

    public Map<String, CachedCompleter> getUniverseInfoCompletersMap() {
        return this.universeInfoCompletersMap;
    }

    private class CursorArgument {
        private boolean universeNamePosition = false;
        private boolean universeNodePosition = false;
        private String universe;
        private String cursorArgumentPartForComplete;

        private CursorArgument() {
        }

        public boolean isUniverseNamePosition() {
            return this.universeNamePosition;
        }

        public void setUniverseNamePosition(boolean universeNamePosition) {
            this.universeNamePosition = universeNamePosition;
        }

        public boolean isUniverseNodePosition() {
            return this.universeNodePosition;
        }

        public void setUniverseNodePosition(boolean universeNodePosition) {
            this.universeNodePosition = universeNodePosition;
        }

        public String getCursorArgumentPartForComplete() {
            return this.cursorArgumentPartForComplete;
        }

        public void setCursorArgumentPartForComplete(String cursorArgumentPartForComplete) {
            this.cursorArgumentPartForComplete = cursorArgumentPartForComplete;
        }

        public String getUniverse() {
            return this.universe;
        }

        public void setUniverse(String universe) {
            this.universe = universe;
        }

        public boolean needLoadUniverses() {
            return this.universe == null;
        }

        public boolean needLoadUniverseInfo() {
            return this.universe != null && this.universeNodePosition;
        }
    }
}

