/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectListener;
import org.apache.zeppelin.display.AngularObjectRegistryListener;

public class AngularObjectRegistry {
    Map<String, Map<String, AngularObject>> registry = new HashMap<String, Map<String, AngularObject>>();
    private final String GLOBAL_KEY = "_GLOBAL_";
    private AngularObjectRegistryListener listener;
    private String interpreterId;
    AngularObjectListener angularObjectListener;

    public AngularObjectRegistry(final String interpreterId, final AngularObjectRegistryListener listener) {
        this.interpreterId = interpreterId;
        this.listener = listener;
        this.angularObjectListener = new AngularObjectListener(){

            @Override
            public void updated(AngularObject updatedObject) {
                if (listener != null) {
                    listener.onUpdate(interpreterId, updatedObject);
                }
            }
        };
    }

    public AngularObjectRegistryListener getListener() {
        return this.listener;
    }

    public AngularObject add(String name, Object o, String noteId, String paragraphId) {
        return this.add(name, o, noteId, paragraphId, true);
    }

    private String getRegistryKey(String noteId, String paragraphId) {
        if (noteId == null) {
            return "_GLOBAL_";
        }
        if (paragraphId == null) {
            return noteId;
        }
        return noteId + "_" + paragraphId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AngularObject> getRegistryForKey(String noteId, String paragraphId) {
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            String key = this.getRegistryKey(noteId, paragraphId);
            if (!this.registry.containsKey(key)) {
                this.registry.put(key, new HashMap());
            }
            return this.registry.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngularObject add(String name, Object o, String noteId, String paragraphId, boolean emit) {
        AngularObject ao = this.createNewAngularObject(name, o, noteId, paragraphId);
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            Map<String, AngularObject> noteLocalRegistry = this.getRegistryForKey(noteId, paragraphId);
            noteLocalRegistry.put(name, ao);
            if (this.listener != null && emit) {
                this.listener.onAdd(this.interpreterId, ao);
            }
        }
        return ao;
    }

    protected AngularObject createNewAngularObject(String name, Object o, String noteId, String paragraphId) {
        return new AngularObject<Object>(name, o, noteId, paragraphId, this.angularObjectListener);
    }

    protected AngularObjectListener getAngularObjectListener() {
        return this.angularObjectListener;
    }

    public AngularObject remove(String name, String noteId, String paragraphId) {
        return this.remove(name, noteId, paragraphId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngularObject remove(String name, String noteId, String paragraphId, boolean emit) {
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            Map<String, AngularObject> r = this.getRegistryForKey(noteId, paragraphId);
            AngularObject o = r.remove(name);
            if (this.listener != null && emit) {
                this.listener.onRemove(this.interpreterId, name, noteId, paragraphId);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String noteId, String paragraphId) {
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            List<AngularObject> all = this.getAll(noteId, paragraphId);
            for (AngularObject ao : all) {
                this.remove(ao.getName(), noteId, paragraphId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AngularObject get(String name, String noteId, String paragraphId) {
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            Map<String, AngularObject> r = this.getRegistryForKey(noteId, paragraphId);
            return r.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AngularObject> getAll(String noteId, String paragraphId) {
        LinkedList<AngularObject> all = new LinkedList<AngularObject>();
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            Map<String, AngularObject> r = this.getRegistryForKey(noteId, paragraphId);
            if (r != null) {
                all.addAll(r.values());
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AngularObject> getAllWithGlobal(String noteId) {
        LinkedList<AngularObject> all = new LinkedList<AngularObject>();
        Map<String, Map<String, AngularObject>> map = this.registry;
        synchronized (map) {
            Map<String, AngularObject> global = this.getRegistryForKey(null, null);
            if (global != null) {
                all.addAll(global.values());
            }
            for (String key : this.registry.keySet()) {
                if (!key.startsWith(noteId)) continue;
                all.addAll(this.registry.get(key).values());
            }
        }
        return all;
    }

    public String getInterpreterGroupId() {
        return this.interpreterId;
    }

    public Map<String, Map<String, AngularObject>> getRegistry() {
        return this.registry;
    }

    public void setRegistry(Map<String, Map<String, AngularObject>> registry) {
        this.registry = registry;
    }
}

