/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterProperty;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Interpreter {
    public static Logger logger = LoggerFactory.getLogger(Interpreter.class);
    private InterpreterGroup interpreterGroup;
    private URL[] classloaderUrls;
    protected Properties property;
    public static Map<String, RegisteredInterpreter> registeredInterpreters = Collections.synchronizedMap(new HashMap());

    @ZeppelinApi
    public abstract void open();

    @ZeppelinApi
    public abstract void close();

    @ZeppelinApi
    public abstract InterpreterResult interpret(String var1, InterpreterContext var2);

    @ZeppelinApi
    public abstract void cancel(InterpreterContext var1);

    @ZeppelinApi
    public abstract FormType getFormType();

    @ZeppelinApi
    public abstract int getProgress(InterpreterContext var1);

    @ZeppelinApi
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        return null;
    }

    @ZeppelinApi
    public Scheduler getScheduler() {
        return SchedulerFactory.singleton().createOrGetFIFOScheduler("interpreter_" + this.hashCode());
    }

    @ZeppelinApi
    public void destroy() {
    }

    @ZeppelinApi
    public Interpreter(Properties property) {
        logger.debug("Properties: {}", (Object)property);
        this.property = property;
    }

    public void setProperty(Properties property) {
        this.property = property;
    }

    @ZeppelinApi
    public Properties getProperty() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.property);
        RegisteredInterpreter registeredInterpreter = Interpreter.findRegisteredInterpreterByClassName(this.getClassName());
        if (null != registeredInterpreter) {
            Map<String, InterpreterProperty> defaultProperties = registeredInterpreter.getProperties();
            for (String k : defaultProperties.keySet()) {
                String value;
                if (p.containsKey(k) || (value = defaultProperties.get(k).getValue()) == null) continue;
                p.put(k, defaultProperties.get(k).getValue());
            }
        }
        return p;
    }

    @ZeppelinApi
    public String getProperty(String key) {
        logger.debug("key: {}, value: {}", (Object)key, (Object)this.getProperty().getProperty(key));
        return this.getProperty().getProperty(key);
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public void setInterpreterGroup(InterpreterGroup interpreterGroup) {
        this.interpreterGroup = interpreterGroup;
    }

    @ZeppelinApi
    public InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    public URL[] getClassloaderUrls() {
        return this.classloaderUrls;
    }

    public void setClassloaderUrls(URL[] classloaderUrls) {
        this.classloaderUrls = classloaderUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ZeppelinApi
    public Interpreter getInterpreterInTheSameSessionByClassName(String className) {
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            for (List interpreters : this.interpreterGroup.values()) {
                boolean belongsToSameNoteGroup = false;
                Interpreter interpreterFound = null;
                for (Interpreter intp : interpreters) {
                    if (intp.getClassName().equals(className)) {
                        interpreterFound = intp;
                    }
                    Interpreter p = intp;
                    while (p instanceof WrappedInterpreter) {
                        p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
                    }
                    if (this != p) continue;
                    belongsToSameNoteGroup = true;
                }
                if (!belongsToSameNoteGroup) continue;
                return interpreterFound;
            }
        }
        return null;
    }

    public static void register(String name, String className) {
        Interpreter.register(name, name, className);
    }

    public static void register(String name, String group, String className) {
        Interpreter.register(name, group, className, new HashMap<String, InterpreterProperty>());
    }

    @Deprecated
    public static void register(String name, String group, String className, Map<String, InterpreterProperty> properties) {
        logger.error("Static initialization is deprecated. You should change it to use interpreter-setting.json in your jar or interpreter/{interpreter}/interpreter-setting.json");
        Interpreter.register(new RegisteredInterpreter(name, group, className, properties));
    }

    public static void register(RegisteredInterpreter registeredInterpreter) {
        String interpreterKey = registeredInterpreter.getInterpreterKey();
        if (!registeredInterpreters.containsKey(interpreterKey)) {
            registeredInterpreters.put(interpreterKey, registeredInterpreter);
        }
    }

    public static RegisteredInterpreter findRegisteredInterpreterByClassName(String className) {
        for (RegisteredInterpreter ri : registeredInterpreters.values()) {
            if (!ri.getClassName().equals(className)) continue;
            return ri;
        }
        return null;
    }

    public static enum SchedulingMode {
        FIFO,
        PARALLEL;

    }

    public static class RegisteredInterpreter {
        private String group;
        private String name;
        private String className;
        private Map<String, InterpreterProperty> properties;
        private String path;

        public RegisteredInterpreter(String name, String group, String className, Map<String, InterpreterProperty> properties) {
            this.name = name;
            this.group = group;
            this.className = className;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        public String getClassName() {
            return this.className;
        }

        public Map<String, InterpreterProperty> getProperties() {
            return this.properties;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public String getInterpreterKey() {
            return this.getGroup() + "." + this.getName();
        }
    }

    public static enum FormType {
        NATIVE,
        SIMPLE,
        NONE;

    }
}

