/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeListener;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeWatcher;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterOutput
extends OutputStream {
    Logger logger = LoggerFactory.getLogger(InterpreterOutput.class);
    private final int NEW_LINE_CHAR = 10;
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final List<Object> outList = new LinkedList<Object>();
    private InterpreterOutputChangeWatcher watcher;
    private final InterpreterOutputListener flushListener;
    private InterpreterResult.Type type = InterpreterResult.Type.TEXT;
    private boolean firstWrite = true;

    public InterpreterOutput(InterpreterOutputListener flushListener) {
        this.flushListener = flushListener;
        this.clear();
    }

    public InterpreterOutput(InterpreterOutputListener flushListener, InterpreterOutputChangeListener listener) throws IOException {
        this.flushListener = flushListener;
        this.clear();
        this.watcher = new InterpreterOutputChangeWatcher(listener);
        this.watcher.start();
    }

    public InterpreterResult.Type getType() {
        return this.type;
    }

    public void setType(InterpreterResult.Type type) {
        if (this.type != type) {
            this.clear();
            this.flushListener.onUpdate(this, new byte[0]);
            this.type = type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<Object> list = this.outList;
        synchronized (list) {
            this.type = InterpreterResult.Type.TEXT;
            this.buffer.reset();
            this.outList.clear();
            if (this.watcher != null) {
                this.watcher.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            this.buffer.write(b);
            if (b == 10) {
                if (this.firstWrite) {
                    this.flushListener.onUpdate(this, new byte[0]);
                    this.firstWrite = false;
                }
                this.flush();
            }
        }
    }

    private byte[] detectTypeFromLine(byte[] byteArray) {
        String line = new String(byteArray);
        for (InterpreterResult.Type t : InterpreterResult.Type.values()) {
            String typeString = '%' + t.name().toLowerCase();
            if ((typeString + "\n").equals(line)) {
                this.setType(t);
                byteArray = null;
                break;
            }
            if (!line.startsWith(typeString + " ")) continue;
            this.setType(t);
            byteArray = line.substring(typeString.length() + 1).getBytes();
            break;
        }
        return byteArray;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }

    public void write(File file) throws IOException {
        this.outList.add(file);
        if (this.watcher != null) {
            this.watcher.watch(file);
        }
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void write(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            this.write(new File(url.getPath()));
        } else {
            this.outList.add(url);
        }
    }

    public void writeResource(String resourceName) throws IOException {
        File mainResource = new File("./src/main/resources/" + resourceName);
        File testResource = new File("./src/test/resources/" + resourceName);
        if (mainResource.isFile()) {
            this.write(mainResource);
        } else if (testResource.isFile()) {
            this.write(testResource);
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            this.write(cl.getResource(resourceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LinkedList<Object> all = new LinkedList<Object>();
        List<Object> list = this.outList;
        synchronized (list) {
            all.addAll(this.outList);
        }
        for (Object e : all) {
            if (e instanceof File) {
                File f = (File)e;
                FileInputStream fin = new FileInputStream(f);
                this.copyStream(fin, out);
                fin.close();
                continue;
            }
            if (e instanceof byte[]) {
                out.write((byte[])e);
                continue;
            }
            if (e instanceof Integer) {
                out.write((Integer)e);
                continue;
            }
            if (!(e instanceof URL)) continue;
            InputStream fin = ((URL)e).openStream();
            this.copyStream(fin, out);
            fin.close();
        }
        out.close();
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        List<Object> list = this.outList;
        synchronized (list) {
            this.buffer.flush();
            byte[] bytes = this.buffer.toByteArray();
            bytes = this.detectTypeFromLine(bytes);
            if (bytes != null) {
                this.outList.add(bytes);
                if (this.type == InterpreterResult.Type.TEXT) {
                    this.flushListener.onAppend(this, bytes);
                }
            }
            this.buffer.reset();
        }
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        int bufferSize = 8192;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher.shutdown();
        }
    }
}

