/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.thrift.TException;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.remote.ClientFactory;
import org.apache.zeppelin.interpreter.remote.InterpreterContextRunnerPool;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterProcess
implements ExecuteResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterProcess.class);
    private final AtomicInteger referenceCount;
    private DefaultExecutor executor;
    private ExecuteWatchdog watchdog;
    boolean running = false;
    private int port = -1;
    private final String interpreterRunner;
    private final String interpreterDir;
    private final String localRepoDir;
    private GenericObjectPool<RemoteInterpreterService.Client> clientPool;
    private Map<String, String> env;
    private final RemoteInterpreterEventPoller remoteInterpreterEventPoller;
    private final InterpreterContextRunnerPool interpreterContextRunnerPool;
    private int connectTimeout;
    String host = "localhost";
    boolean isInterpreterAlreadyExecuting = false;

    public RemoteInterpreterProcess(String intpRunner, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, RemoteInterpreterProcessListener listener) {
        this(intpRunner, intpDir, localRepoDir, env, new RemoteInterpreterEventPoller(listener), connectTimeout);
    }

    RemoteInterpreterProcess(String intpRunner, String intpDir, String localRepoDir, Map<String, String> env, RemoteInterpreterEventPoller remoteInterpreterEventPoller, int connectTimeout) {
        this.interpreterRunner = intpRunner;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
        this.env = env;
        this.interpreterContextRunnerPool = new InterpreterContextRunnerPool();
        this.referenceCount = new AtomicInteger(0);
        this.remoteInterpreterEventPoller = remoteInterpreterEventPoller;
        this.connectTimeout = connectTimeout;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reference(InterpreterGroup interpreterGroup) {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            if (this.executor == null) {
                if (interpreterGroup.containsKey("existing_process")) {
                    Properties properties = interpreterGroup.getProperty();
                    this.isInterpreterAlreadyExecuting = true;
                    if (this.isInterpreterAlreadyExecuting) {
                        if (!properties.containsKey("zeppelin.interpreter.host")) {
                            throw new InterpreterException("Can't find value for option Host.Please specify the host on which interpreter is executing");
                        }
                        this.host = properties.getProperty("zeppelin.interpreter.host");
                        if (properties.containsKey("zeppelin.interpreter.port")) {
                            this.port = Integer.parseInt(interpreterGroup.getProperty().getProperty("zeppelin.interpreter.port"));
                        } else {
                            throw new InterpreterException("Can't find value for option Port.Please specify the port on which interpreter is listening");
                        }
                    }
                    this.running = true;
                }
                if (!this.isInterpreterAlreadyExecuting) {
                    try {
                        this.port = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
                    }
                    catch (IOException e1) {
                        throw new InterpreterException(e1);
                    }
                    CommandLine cmdLine = CommandLine.parse(this.interpreterRunner);
                    cmdLine.addArgument("-d", false);
                    cmdLine.addArgument(this.interpreterDir, false);
                    cmdLine.addArgument("-p", false);
                    cmdLine.addArgument(Integer.toString(this.port), false);
                    cmdLine.addArgument("-l", false);
                    cmdLine.addArgument(this.localRepoDir, false);
                    this.executor = new DefaultExecutor();
                    this.watchdog = new ExecuteWatchdog(-1L);
                    this.executor.setWatchdog(this.watchdog);
                    this.running = true;
                    try {
                        Map<String, String> procEnv = EnvironmentUtils.getProcEnvironment();
                        procEnv.putAll(this.env);
                        logger.info("Run interpreter process {}", (Object)cmdLine);
                        this.executor.execute(cmdLine, procEnv, this);
                    }
                    catch (IOException e) {
                        this.running = false;
                        throw new InterpreterException(e);
                    }
                }
                logger.info("Not starting interpreter as \"isExistingProcess\" is enabled");
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < (long)this.connectTimeout && !RemoteInterpreterUtils.checkIfRemoteEndpointAccessible(this.host, this.port)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Exception in RemoteInterpreterProcess while synchronized reference Thread.sleep", e);
                    }
                }
                this.clientPool = new GenericObjectPool<RemoteInterpreterService.Client>(new ClientFactory(this.host, this.port));
                this.remoteInterpreterEventPoller.setInterpreterGroup(interpreterGroup);
                this.remoteInterpreterEventPoller.setInterpreterProcess(this);
                this.remoteInterpreterEventPoller.start();
            }
            return this.referenceCount.incrementAndGet();
        }
    }

    public RemoteInterpreterService.Client getClient() throws Exception {
        if (this.clientPool == null || this.clientPool.isClosed()) {
            return null;
        }
        return this.clientPool.borrowObject();
    }

    public void releaseClient(RemoteInterpreterService.Client client) {
        this.releaseClient(client, false);
    }

    public void releaseClient(RemoteInterpreterService.Client client, boolean broken) {
        if (broken) {
            this.releaseBrokenClient(client);
        } else {
            try {
                this.clientPool.returnObject(client);
            }
            catch (Exception e) {
                logger.warn("exception occurred during releasing thrift client", e);
            }
        }
    }

    public void releaseBrokenClient(RemoteInterpreterService.Client client) {
        try {
            this.clientPool.invalidateObject(client);
        }
        catch (Exception e) {
            logger.warn("exception occurred during releasing thrift client", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dereference() {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            int r = this.referenceCount.decrementAndGet();
            if (r == 0) {
                logger.info("shutdown interpreter process");
                this.remoteInterpreterEventPoller.shutdown();
                RemoteInterpreterService.Client client = null;
                try {
                    client = this.getClient();
                    client.shutdown();
                }
                catch (Exception e) {
                    logger.info("Exception in RemoteInterpreterProcess while synchronized dereference, can safely ignore exception while client.shutdown() may terminates remote process");
                    logger.debug(e.getMessage(), e);
                }
                finally {
                    if (client != null) {
                        this.releaseBrokenClient(client);
                    }
                }
                this.clientPool.clear();
                this.clientPool.close();
                long startTime = System.currentTimeMillis();
                while (System.currentTimeMillis() - startTime < (long)this.connectTimeout && this.isRunning()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Exception in RemoteInterpreterProcess while synchronized dereference Thread.sleep", e);
                    }
                }
                if (this.isRunning()) {
                    logger.info("kill interpreter process");
                    this.watchdog.destroyProcess();
                }
                this.executor = null;
                this.watchdog = null;
                this.running = false;
                logger.info("Remote process terminated");
            }
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int referenceCount() {
        AtomicInteger atomicInteger = this.referenceCount;
        synchronized (atomicInteger) {
            return this.referenceCount.get();
        }
    }

    @Override
    public void onProcessComplete(int exitValue) {
        logger.info("Interpreter process exited {}", (Object)exitValue);
        this.running = false;
    }

    @Override
    public void onProcessFailed(ExecuteException e) {
        logger.info("Interpreter process failed {}", e);
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getNumActiveClient() {
        if (this.clientPool == null) {
            return 0;
        }
        return this.clientPool.getNumActive();
    }

    public int getNumIdleClient() {
        if (this.clientPool == null) {
            return 0;
        }
        return this.clientPool.getNumIdle();
    }

    public void setMaxPoolSize(int size) {
        if (this.clientPool != null) {
            this.clientPool.setMaxTotal(size + 2);
        }
    }

    public int getMaxPoolSize() {
        if (this.clientPool != null) {
            return this.clientPool.getMaxTotal();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRemoteAngularObject(String name, String noteId, String paragraphId, Object o) {
        RemoteInterpreterService.Client client = null;
        try {
            client = this.getClient();
        }
        catch (NullPointerException e) {
            logger.info("NullPointerException in RemoteInterpreterProcess while updateRemoteAngularObject getClient, remote process not started", e);
            return;
        }
        catch (Exception e) {
            logger.error("Can't update angular object", e);
        }
        boolean broken = false;
        try {
            Gson gson = new Gson();
            client.angularObjectUpdate(name, noteId, paragraphId, gson.toJson(o));
        }
        catch (TException e) {
            broken = true;
            logger.error("Can't update angular object", e);
        }
        catch (NullPointerException e) {
            logger.error("Remote interpreter process not started", e);
            return;
        }
        finally {
            if (client != null) {
                this.releaseClient(client, broken);
            }
        }
    }

    public InterpreterContextRunnerPool getInterpreterContextRunnerPool() {
        return this.interpreterContextRunnerPool;
    }
}

