/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.listener;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryEvent
implements RepositoryEvent {
    private RepositoryEvent.EventType type;
    private RepositorySystemSession session;
    private Artifact artifact;
    private Metadata metadata;
    private ArtifactRepository repository;
    private File file;
    private List<Exception> exceptions = Collections.emptyList();
    private RequestTrace trace;

    @Deprecated
    public DefaultRepositoryEvent(RepositoryEvent.EventType type, RepositorySystemSession session) {
        this(type, session, null);
    }

    public DefaultRepositoryEvent(RepositoryEvent.EventType type, RepositorySystemSession session, RequestTrace trace) {
        this.setType(type);
        this.setSession(session);
        this.setTrace(trace);
    }

    @Override
    public RepositoryEvent.EventType getType() {
        return this.type;
    }

    private DefaultRepositoryEvent setType(RepositoryEvent.EventType type) {
        if (type == null) {
            throw new IllegalArgumentException("event type not specified");
        }
        this.type = type;
        return this;
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    private DefaultRepositoryEvent setSession(RepositorySystemSession session) {
        if (session == null) {
            throw new IllegalArgumentException("session not specified");
        }
        this.session = session;
        return this;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public DefaultRepositoryEvent setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public DefaultRepositoryEvent setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public DefaultRepositoryEvent setRepository(ArtifactRepository repository) {
        this.repository = repository;
        return this;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public DefaultRepositoryEvent setFile(File file) {
        this.file = file;
        return this;
    }

    @Override
    public Exception getException() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    public DefaultRepositoryEvent setException(Exception exception) {
        this.exceptions = exception != null ? Collections.singletonList(exception) : Collections.emptyList();
        return this;
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public DefaultRepositoryEvent setExceptions(List<Exception> exceptions) {
        this.exceptions = exceptions != null ? exceptions : Collections.emptyList();
        return this;
    }

    @Override
    public RequestTrace getTrace() {
        return this.trace;
    }

    public DefaultRepositoryEvent setTrace(RequestTrace trace) {
        this.trace = trace;
        return this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append((Object)this.getType());
        if (this.getArtifact() != null) {
            buffer.append(" ").append(this.getArtifact());
        }
        if (this.getMetadata() != null) {
            buffer.append(" ").append(this.getMetadata());
        }
        if (this.getFile() != null) {
            buffer.append(" (").append(this.getFile()).append(")");
        }
        if (this.getRepository() != null) {
            buffer.append(" @ ").append(this.getRepository());
        }
        return buffer.toString();
    }
}

