/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;

public class InterpreterGroup
extends ConcurrentHashMap<String, List<Interpreter>> {
    String id;
    Logger LOGGER = Logger.getLogger(InterpreterGroup.class);
    AngularObjectRegistry angularObjectRegistry;
    RemoteInterpreterProcess remoteInterpreterProcess;
    ResourcePool resourcePool;
    boolean angularRegistryPushed = false;
    private static final Map<String, InterpreterGroup> allInterpreterGroups = new ConcurrentHashMap<String, InterpreterGroup>();

    public static InterpreterGroup getByInterpreterGroupId(String id) {
        return allInterpreterGroups.get(id);
    }

    public static Collection<InterpreterGroup> getAll() {
        return new LinkedList<InterpreterGroup>(allInterpreterGroups.values());
    }

    public InterpreterGroup(String id) {
        this.id = id;
        allInterpreterGroups.put(id, this);
    }

    public InterpreterGroup() {
        this.getId();
        allInterpreterGroups.put(this.id, this);
    }

    private static String generateId() {
        return "InterpreterGroup_" + System.currentTimeMillis() + "_" + new Random().nextInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        InterpreterGroup interpreterGroup = this;
        synchronized (interpreterGroup) {
            if (this.id == null) {
                this.id = InterpreterGroup.generateId();
            }
            return this.id;
        }
    }

    public Properties getProperty() {
        Iterator i$;
        Properties p = new Properties();
        Collection intpGroupForANote = this.values();
        if (intpGroupForANote != null && intpGroupForANote.size() > 0 && (i$ = intpGroupForANote.iterator()).hasNext()) {
            List intpGroup = (List)i$.next();
            for (Interpreter intp : intpGroup) {
                p.putAll((Map<?, ?>)intp.getProperty());
            }
        }
        return p;
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public void setAngularObjectRegistry(AngularObjectRegistry angularObjectRegistry) {
        this.angularObjectRegistry = angularObjectRegistry;
    }

    public RemoteInterpreterProcess getRemoteInterpreterProcess() {
        return this.remoteInterpreterProcess;
    }

    public void setRemoteInterpreterProcess(RemoteInterpreterProcess remoteInterpreterProcess) {
        this.remoteInterpreterProcess = remoteInterpreterProcess;
    }

    public void close() {
        this.LOGGER.info("Close interpreter group " + this.getId());
        LinkedList<Interpreter> intpToClose = new LinkedList<Interpreter>();
        for (List intpGroupForNote : this.values()) {
            intpToClose.addAll(intpGroupForNote);
        }
        this.close(intpToClose);
    }

    public void close(String noteId) {
        this.LOGGER.info("Close interpreter group " + this.getId() + " for note " + noteId);
        List intpForNote = (List)this.get(noteId);
        this.close(intpForNote);
    }

    private void close(Collection<Interpreter> intpToClose) {
        if (intpToClose == null) {
            return;
        }
        LinkedList<1> closeThreads = new LinkedList<1>();
        for (final Interpreter interpreter : intpToClose) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    Scheduler scheduler = interpreter.getScheduler();
                    interpreter.close();
                    if (scheduler != null) {
                        SchedulerFactory.singleton().removeScheduler(scheduler.getName());
                    }
                }
            };
            t.start();
            closeThreads.add(t);
        }
        for (Thread thread : closeThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                this.LOGGER.error("Can't close interpreter", e);
            }
        }
    }

    public void destroy(String noteId) {
        this.LOGGER.info("Destroy interpreter group " + this.getId() + " for note " + noteId);
        List intpForNote = (List)this.get(noteId);
        this.destroy(intpForNote);
    }

    public void destroy() {
        this.LOGGER.info("Destroy interpreter group " + this.getId());
        LinkedList<Interpreter> intpToDestroy = new LinkedList<Interpreter>();
        for (List intpGroupForNote : this.values()) {
            intpToDestroy.addAll(intpGroupForNote);
        }
        this.destroy(intpToDestroy);
        if (this.remoteInterpreterProcess != null) {
            while (this.remoteInterpreterProcess.referenceCount() > 0) {
                this.remoteInterpreterProcess.dereference();
            }
        }
        allInterpreterGroups.remove(this.id);
    }

    private void destroy(Collection<Interpreter> intpToDestroy) {
        if (intpToDestroy == null) {
            return;
        }
        LinkedList<2> destroyThreads = new LinkedList<2>();
        for (final Interpreter interpreter : intpToDestroy) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    interpreter.destroy();
                }
            };
            t.start();
            destroyThreads.add(t);
        }
        for (Thread thread : destroyThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                this.LOGGER.error("Can't close interpreter", e);
            }
        }
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public boolean isAngularRegistryPushed() {
        return this.angularRegistryPushed;
    }

    public void setAngularRegistryPushed(boolean angularRegistryPushed) {
        this.angularRegistryPushed = angularRegistryPushed;
    }
}

