/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.ProviderLookup;
import com.google.inject.spi.StaticInjectionRequest;
import com.google.inject.spi.UntargettedBinding;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonatype.guice.bean.binders.ParameterKeys;
import org.sonatype.guice.bean.reflect.DeferredProvider;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.reflect.TypeParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DependencyAnalyzer
extends DefaultBindingTargetVisitor<Object, Boolean> {
    private final Map<TypeLiteral<?>, Boolean> cachedResults = new HashMap();
    private final Set<Key<?>> requiredKeys = new HashSet();

    DependencyAnalyzer() {
        this.requiredKeys.add(ParameterKeys.PROPERTIES);
    }

    public Set<Key<?>> getRequiredKeys() {
        return this.requiredKeys;
    }

    @Override
    public Boolean visit(UntargettedBinding<?> binding) {
        return this.analyzeImplementation(binding.getKey().getTypeLiteral());
    }

    @Override
    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key<?> linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return this.analyzeImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderKeyBinding<?> binding) {
        Key<javax.inject.Provider<?>> providerKey = binding.getProviderKey();
        if (providerKey.getAnnotationType() == null) {
            return this.analyzeImplementation(providerKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean visit(ProviderInstanceBinding<?> binding) {
        Provider<?> provider = binding.getProviderInstance();
        if (provider instanceof DeferredProvider) {
            try {
                this.analyzeImplementation(TypeLiteral.get(((DeferredProvider)provider).getImplementationClass().load()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return Boolean.TRUE;
        }
        return this.analyzeDependencies(binding.getDependencies());
    }

    @Override
    public Boolean visitOther(Binding<?> binding) {
        if (binding instanceof HasDependencies) {
            return this.analyzeDependencies(((HasDependencies)((Object)binding)).getDependencies());
        }
        return Boolean.TRUE;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        this.requiredKeys.add(lookup.getKey());
        return Boolean.TRUE;
    }

    public Boolean visit(StaticInjectionRequest request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        return this.analyzeInjectionPoints(request.getInjectionPoints());
    }

    private Boolean analyzeImplementation(TypeLiteral<?> type) {
        Boolean applyBinding = this.cachedResults.get(type);
        if (null == applyBinding) {
            boolean result = true;
            if ((type.getRawType().getModifiers() & 0x600) == 0) {
                try {
                    result = this.analyzeDependencies(InjectionPoint.forConstructorOf(type).getDependencies());
                    result &= this.analyzeInjectionPoints(InjectionPoint.forInstanceMethodsAndFields(type));
                }
                catch (Throwable e) {
                    Logs.debug("Ignore: {}", type, e);
                    result = false;
                }
            }
            applyBinding = result;
            this.cachedResults.put(type, applyBinding);
        }
        return applyBinding;
    }

    private boolean analyzeInjectionPoints(Set<InjectionPoint> points) {
        boolean applyBinding = true;
        for (InjectionPoint p : points) {
            applyBinding &= this.analyzeDependencies(p.getDependencies());
        }
        return applyBinding;
    }

    private boolean analyzeDependencies(Collection<Dependency<?>> dependencies) {
        boolean applyBinding = true;
        for (Dependency<?> d : dependencies) {
            Key<?> key = d.getKey();
            if (key.hasAttributes() && "Assisted".equals(key.getAnnotationType().getSimpleName())) {
                applyBinding = false;
                continue;
            }
            Class<?> clazz = key.getTypeLiteral().getRawType();
            if (javax.inject.Provider.class == clazz || Provider.class == clazz) {
                this.requiredKeys.add(key.ofType(TypeParameters.get(key.getTypeLiteral(), 0)));
                continue;
            }
            this.requiredKeys.add(key);
        }
        return applyBinding;
    }
}

