/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeConverter;
import com.google.inject.spi.TypeConverterBinding;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.guice.bean.binders.BeanProvider;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.inject.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PlaceholderBeanProvider<V>
implements Provider<V> {
    private static final int EXPRESSION_RECURSION_LIMIT = 8;
    @Inject
    @Parameters
    Map<String, String> properties;
    @Inject
    private BeanLocator locator;
    private TypeConverter typeConverter;
    private final Key<V> placeholderKey;

    PlaceholderBeanProvider(Key<V> key) {
        this.placeholderKey = key;
    }

    @Override
    public V get() {
        TypeLiteral<V> beanType = this.placeholderKey.getTypeLiteral();
        String config = this.interpolate(((Named)this.placeholderKey.getAnnotation()).value());
        if ("null".equals(config)) {
            return null;
        }
        if (null != this.typeConverter) {
            return (V)this.typeConverter.convert(config, beanType);
        }
        if (String.class == beanType.getRawType()) {
            return (V)config;
        }
        return BeanProvider.get(this.locator, Key.get(beanType, (Annotation)Names.named(config)));
    }

    @Inject
    void setTypeConverterBindings(Injector injector) {
        TypeLiteral<V> beanType = this.placeholderKey.getTypeLiteral();
        for (TypeConverterBinding b : injector.getTypeConverterBindings()) {
            if (!b.getTypeMatcher().matches(beanType)) continue;
            this.typeConverter = b.getTypeConverter();
            break;
        }
    }

    private String interpolate(String placeholder) {
        int y;
        StringBuilder buf = new StringBuilder(placeholder);
        int x = 0;
        int expressionEnd = 0;
        int expressionNum = 0;
        while ((x = buf.indexOf("${", x)) >= 0 && (y = buf.indexOf("}", x) + 1) > 0) {
            String key;
            int anchor;
            String value;
            if (y > expressionEnd) {
                expressionNum = 0;
                expressionEnd = y;
            }
            if ((value = this.properties.get((anchor = (key = buf.substring(x + 2, y - 1)).indexOf(":-")) < 0 ? key : key.substring(0, anchor))) == null && anchor >= 0) {
                value = key.substring(anchor + 2);
            }
            if (expressionNum++ >= 8) {
                throw new ProvisionException("Recursive configuration: " + placeholder + " stopped at: " + buf);
            }
            int len = buf.length();
            buf.replace(x, y, String.valueOf(value));
            expressionEnd += buf.length() - len;
        }
        return buf.toString();
    }
}

