/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.nio.file.Paths;
import org.apache.commons.lang.Validate;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.zeppelin.dep.RepositorySystemFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;

public class Booter {
    public static RepositorySystem newRepositorySystem() {
        return RepositorySystemFactory.newRepositorySystem();
    }

    public static RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoPath) {
        Validate.notNull((Object)localRepoPath, (String)"localRepoPath should have a value");
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(Booter.resolveLocalRepoPath(localRepoPath));
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        return session;
    }

    static String resolveLocalRepoPath(String localRepoPath) {
        String home = System.getenv("ZEPPELIN_HOME");
        if (home == null) {
            home = System.getProperty("zeppelin.home");
        }
        if (home == null) {
            home = "..";
        }
        return Paths.get(home, new String[0]).resolve(localRepoPath).toAbsolutePath().toString();
    }

    public static RemoteRepository newCentralRepository() {
        String mvnRepo = System.getenv("ZEPPELIN_INTERPRETER_DEP_MVNREPO");
        if (mvnRepo == null) {
            mvnRepo = System.getProperty("zeppelin.interpreter.dep.mvnRepo");
        }
        if (mvnRepo == null) {
            mvnRepo = "http://repo1.maven.org/maven2/";
        }
        return new RemoteRepository("central", "default", mvnRepo);
    }

    public static RemoteRepository newLocalRepository() {
        return new RemoteRepository("local", "default", "file://" + System.getProperty("user.home") + "/.m2/repository");
    }
}

