/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zeppelin.dep.AbstractDependencyResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;
import org.sonatype.aether.util.filter.PatternExclusionsDependencyFilter;

public class DependencyResolver
extends AbstractDependencyResolver {
    Logger logger = LoggerFactory.getLogger(DependencyResolver.class);
    private final String[] exclusions = new String[]{"org.apache.zeppelin:zeppelin-zengine", "org.apache.zeppelin:zeppelin-interpreter", "org.apache.zeppelin:zeppelin-server"};

    public DependencyResolver(String localRepoPath) {
        super(localRepoPath);
    }

    public List<File> load(String artifact) throws RepositoryException, IOException {
        return this.load(artifact, new LinkedList<String>());
    }

    public synchronized List<File> load(String artifact, Collection<String> excludes) throws RepositoryException, IOException {
        if (StringUtils.isBlank((String)artifact)) {
            return new LinkedList<File>();
        }
        int numSplits = artifact.split(":").length;
        if (numSplits >= 3 && numSplits <= 6) {
            return this.loadFromMvn(artifact, excludes);
        }
        LinkedList<File> libs = new LinkedList<File>();
        libs.add(new File(artifact));
        return libs;
    }

    public List<File> load(String artifact, File destPath) throws IOException, RepositoryException {
        return this.load(artifact, new LinkedList<String>(), destPath);
    }

    public List<File> load(String artifact, Collection<String> excludes, File destPath) throws RepositoryException, IOException {
        List<File> libs = new LinkedList<File>();
        if (StringUtils.isNotBlank((String)artifact)) {
            libs = this.load(artifact, excludes);
            for (File srcFile : libs) {
                File destFile = new File(destPath, srcFile.getName());
                if (destFile.exists() && FileUtils.contentEquals((File)srcFile, (File)destFile)) continue;
                FileUtils.copyFile((File)srcFile, (File)destFile);
                this.logger.debug("copy {} to {}", (Object)srcFile.getAbsolutePath(), (Object)destPath);
            }
        }
        return libs;
    }

    public synchronized void copyLocalDependency(String srcPath, File destPath) throws IOException {
        if (StringUtils.isBlank((String)srcPath)) {
            return;
        }
        File srcFile = new File(srcPath);
        File destFile = new File(destPath, srcFile.getName());
        if (!destFile.exists() || !FileUtils.contentEquals((File)srcFile, (File)destFile)) {
            FileUtils.copyFile((File)srcFile, (File)destFile);
            this.logger.debug("copy {} to {}", (Object)srcFile.getAbsolutePath(), (Object)destPath);
        }
    }

    private List<File> loadFromMvn(String artifact, Collection<String> excludes) throws RepositoryException {
        LinkedList<String> allExclusions = new LinkedList<String>();
        allExclusions.addAll(excludes);
        allExclusions.addAll(Arrays.asList(this.exclusions));
        List<ArtifactResult> listOfArtifact = this.getArtifactsWithDep(artifact, allExclusions);
        Iterator<ArtifactResult> it = listOfArtifact.iterator();
        block0: while (it.hasNext()) {
            Artifact a = it.next().getArtifact();
            String gav = a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion();
            for (String exclude : allExclusions) {
                if (!gav.startsWith(exclude)) continue;
                it.remove();
                continue block0;
            }
        }
        LinkedList<File> files = new LinkedList<File>();
        for (ArtifactResult artifactResult : listOfArtifact) {
            files.add(artifactResult.getArtifact().getFile());
            this.logger.debug("load {}", (Object)artifactResult.getArtifact().getFile().getAbsolutePath());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArtifactResult> getArtifactsWithDep(String dependency, Collection<String> excludes) throws RepositoryException {
        DefaultArtifact artifact = new DefaultArtifact(dependency);
        DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"});
        PatternExclusionsDependencyFilter exclusionFilter = new PatternExclusionsDependencyFilter(excludes);
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency((Artifact)artifact, "compile"));
        List list = this.repos;
        synchronized (list) {
            for (RemoteRepository repo : this.repos) {
                collectRequest.addRepository(repo);
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{exclusionFilter, classpathFilter}));
        try {
            return this.system.resolveDependencies(this.session, dependencyRequest).getArtifactResults();
        }
        catch (NullPointerException ex) {
            throw new RepositoryException(String.format("Cannot fetch dependencies for %s", dependency));
        }
    }
}

