/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.display;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.zeppelin.display.Input;

public class GUI
implements Serializable {
    Map<String, Object> params = new HashMap<String, Object>();
    LinkedHashMap<String, Input> forms = new LinkedHashMap();

    public void setParams(Map<String, Object> values) {
        this.params = values;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public LinkedHashMap<String, Input> getForms() {
        return this.forms;
    }

    public void setForms(LinkedHashMap<String, Input> forms) {
        this.forms = forms;
    }

    public Object input(String id, Object defaultValue) {
        Object value = this.params.get(id);
        if (value == null) {
            value = defaultValue;
        }
        this.forms.put(id, new Input(id, defaultValue, "input"));
        return value;
    }

    public Object input(String id) {
        return this.input(id, "");
    }

    public Object select(String id, Object defaultValue, Input.ParamOption[] options) {
        Object value = this.params.get(id);
        if (value == null) {
            value = defaultValue;
        }
        this.forms.put(id, new Input(id, defaultValue, "select", options));
        return value;
    }

    public Collection<Object> checkbox(String id, Collection<Object> defaultChecked, Input.ParamOption[] options) {
        Collection<Object> checked = (Collection<Object>)this.params.get(id);
        if (checked == null) {
            checked = defaultChecked;
        }
        this.forms.put(id, new Input(id, defaultChecked, "checkbox", options));
        LinkedList<Object> filtered = new LinkedList<Object>();
        for (Object o : checked) {
            if (!this.isValidOption(o, options)) continue;
            filtered.add(o);
        }
        return filtered;
    }

    private boolean isValidOption(Object o, Input.ParamOption[] options) {
        for (Input.ParamOption option : options) {
            if (!o.equals(option.getValue())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.forms = new LinkedHashMap();
    }
}

