/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.HashMap;
import java.util.Map;

public class InterpreterHookRegistry {
    public static final String GLOBAL_KEY = "_GLOBAL_";
    private String interpreterId;
    private Map<String, Map<String, Map<String, String>>> registry = new HashMap<String, Map<String, Map<String, String>>>();

    public InterpreterHookRegistry(String interpreterId) {
        this.interpreterId = interpreterId;
    }

    public String getInterpreterId() {
        return this.interpreterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNote(String noteId) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (this.registry.get(noteId) == null) {
                this.registry.put(noteId, new HashMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepl(String noteId, String className) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            this.addNote(noteId);
            if (this.registry.get(noteId).get(className) == null) {
                this.registry.get(noteId).put(className, new HashMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String noteId, String className, String event, String cmd) throws IllegalArgumentException {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            if (!(event.equals("post_exec") || event.equals("pre_exec") || event.equals("post_exec_dev") || event.equals("pre_exec_dev"))) {
                throw new IllegalArgumentException("Must be post_exec, post_exec_dev, pre_exec or pre_exec_dev");
            }
            this.registry.get(noteId).get(className).put(event, cmd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String noteId, String className, String event) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            this.registry.get(noteId).get(className).remove(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String noteId, String className, String event) {
        Map<String, Map<String, Map<String, String>>> map = this.registry;
        synchronized (map) {
            if (noteId == null) {
                noteId = GLOBAL_KEY;
            }
            this.addRepl(noteId, className);
            return this.registry.get(noteId).get(className).get(event);
        }
    }

    public static final class HookType {
        public static final String PRE_EXEC = "pre_exec";
        public static final String POST_EXEC = "post_exec";
        public static final String PRE_EXEC_DEV = "pre_exec_dev";
        public static final String POST_EXEC_DEV = "post_exec_dev";
    }
}

