/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.thrift.TException;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.Input;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.WrappedInterpreter;
import org.apache.zeppelin.interpreter.remote.InterpreterContextRunnerPool;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterManagedProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterContext;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreter
extends Interpreter {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreter.class);
    private final RemoteInterpreterProcessListener remoteInterpreterProcessListener;
    private final ApplicationEventListener applicationEventListener;
    private Gson gson = new Gson();
    private String interpreterRunner;
    private String interpreterPath;
    private String localRepoPath;
    private String className;
    private String sessionKey;
    private Interpreter.FormType formType;
    private boolean initialized;
    private Map<String, String> env;
    private int connectTimeout;
    private int maxPoolSize;
    private String host;
    private int port;
    private String userName;
    private Boolean isUserImpersonate;
    private int outputLimit = 102400;

    public RemoteInterpreter(Properties property, String sessionKey, String className, String interpreterRunner, String interpreterPath, String localRepoPath, int connectTimeout, int maxPoolSize, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appListener, String userName, Boolean isUserImpersonate, int outputLimit) {
        super(property);
        this.sessionKey = sessionKey;
        this.className = className;
        this.initialized = false;
        this.interpreterRunner = interpreterRunner;
        this.interpreterPath = interpreterPath;
        this.localRepoPath = localRepoPath;
        this.env = this.getEnvFromInterpreterProperty(property);
        this.connectTimeout = connectTimeout;
        this.maxPoolSize = maxPoolSize;
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        this.applicationEventListener = appListener;
        this.userName = userName;
        this.isUserImpersonate = isUserImpersonate;
        this.outputLimit = outputLimit;
    }

    public RemoteInterpreter(Properties property, String sessionKey, String className, String host, int port, String localRepoPath, int connectTimeout, int maxPoolSize, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appListener, String userName, Boolean isUserImpersonate, int outputLimit) {
        super(property);
        this.sessionKey = sessionKey;
        this.className = className;
        this.initialized = false;
        this.host = host;
        this.port = port;
        this.localRepoPath = localRepoPath;
        this.connectTimeout = connectTimeout;
        this.maxPoolSize = maxPoolSize;
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        this.applicationEventListener = appListener;
        this.userName = userName;
        this.isUserImpersonate = isUserImpersonate;
        this.outputLimit = outputLimit;
    }

    public RemoteInterpreter(Properties property, String sessionKey, String className, String interpreterRunner, String interpreterPath, String localRepoPath, Map<String, String> env, int connectTimeout, RemoteInterpreterProcessListener remoteInterpreterProcessListener, ApplicationEventListener appListener, String userName, Boolean isUserImpersonate) {
        super(property);
        this.className = className;
        this.sessionKey = sessionKey;
        this.interpreterRunner = interpreterRunner;
        this.interpreterPath = interpreterPath;
        this.localRepoPath = localRepoPath;
        env.putAll(this.getEnvFromInterpreterProperty(property));
        this.env = env;
        this.connectTimeout = connectTimeout;
        this.maxPoolSize = 10;
        this.remoteInterpreterProcessListener = remoteInterpreterProcessListener;
        this.applicationEventListener = appListener;
        this.userName = userName;
        this.isUserImpersonate = isUserImpersonate;
    }

    private Map<String, String> getEnvFromInterpreterProperty(Properties property) {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Object key : property.keySet()) {
            if (!RemoteInterpreter.isEnvString((String)key)) continue;
            env.put((String)key, property.getProperty((String)key));
        }
        return env;
    }

    static boolean isEnvString(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return key.matches("^[A-Z_0-9]*");
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    private boolean connectToExistingProcess() {
        return this.host != null && this.port > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteInterpreterProcess getInterpreterProcess() {
        InterpreterGroup intpGroup = this.getInterpreterGroup();
        if (intpGroup == null) {
            return null;
        }
        InterpreterGroup interpreterGroup = intpGroup;
        synchronized (interpreterGroup) {
            if (intpGroup.getRemoteInterpreterProcess() == null) {
                RemoteInterpreterProcess remoteProcess = this.connectToExistingProcess() ? new RemoteInterpreterRunningProcess(this.connectTimeout, this.remoteInterpreterProcessListener, this.applicationEventListener, this.host, this.port) : new RemoteInterpreterManagedProcess(this.interpreterRunner, this.interpreterPath, this.localRepoPath, this.env, this.connectTimeout, this.remoteInterpreterProcessListener, this.applicationEventListener);
                intpGroup.setRemoteInterpreterProcess(remoteProcess);
            }
            return intpGroup.getRemoteInterpreterProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        InterpreterGroup interpreterGroup = this.getInterpreterGroup();
        interpreterProcess.setMaxPoolSize(Math.max(this.maxPoolSize, interpreterProcess.getMaxPoolSize()));
        String groupId = interpreterGroup.getId();
        RemoteInterpreterProcess remoteInterpreterProcess = interpreterProcess;
        synchronized (remoteInterpreterProcess) {
            RemoteInterpreterService.Client client = null;
            try {
                client = interpreterProcess.getClient();
            }
            catch (Exception e1) {
                throw new InterpreterException(e1);
            }
            boolean broken = false;
            try {
                logger.info("Create remote interpreter {}", (Object)this.getClassName());
                if (this.localRepoPath != null) {
                    this.property.put("zeppelin.interpreter.localRepo", this.localRepoPath);
                }
                this.property.put("zeppelin.interpreter.output.limit", Integer.toString(this.outputLimit));
                client.createInterpreter(groupId, this.sessionKey, this.getClassName(), this.property, this.userName);
                if (!interpreterGroup.isAngularRegistryPushed()) {
                    this.pushAngularObjectRegistryToRemote(client);
                    interpreterGroup.setAngularRegistryPushed(true);
                }
            }
            catch (TException e) {
                logger.error("Failed to create interpreter: {}", (Object)this.getClassName());
                throw new InterpreterException(e);
            }
            finally {
                interpreterProcess.releaseClient(client, broken);
            }
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        InterpreterGroup interpreterGroup;
        InterpreterGroup interpreterGroup2 = interpreterGroup = this.getInterpreterGroup();
        synchronized (interpreterGroup2) {
            List interpreters = (List)interpreterGroup.get(this.sessionKey);
            RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
            if (!this.initialized) {
                interpreterProcess.reference(interpreterGroup, this.userName, this.isUserImpersonate);
            }
            Iterator i$ = new ArrayList(interpreters).iterator();
            while (i$.hasNext()) {
                Interpreter intp;
                Interpreter p = intp = (Interpreter)i$.next();
                while (p instanceof WrappedInterpreter) {
                    p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
                }
                try {
                    ((RemoteInterpreter)p).init();
                }
                catch (InterpreterException e) {
                    logger.error("Failed to initialize interpreter: {}. Remove it from interpreterGroup", (Object)p.getClassName());
                    interpreters.remove(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        InterpreterGroup interpreterGroup;
        InterpreterGroup interpreterGroup2 = interpreterGroup = this.getInterpreterGroup();
        synchronized (interpreterGroup2) {
            List interpreters = (List)interpreterGroup.get(this.sessionKey);
            if (this.initialized) {
                this.getInterpreterProcess().dereference();
            }
            Iterator i$ = new ArrayList(interpreters).iterator();
            while (i$.hasNext()) {
                Interpreter intp;
                Interpreter p = intp = (Interpreter)i$.next();
                while (p instanceof WrappedInterpreter) {
                    p = ((WrappedInterpreter)((Object)p)).getInnerInterpreter();
                }
                try {
                    ((RemoteInterpreter)p).closeInterpreter();
                }
                catch (InterpreterException e) {
                    logger.error("Failed to initialize interpreter: {}. Remove it from interpreterGroup", (Object)p.getClassName());
                    interpreters.remove(p);
                }
            }
        }
    }

    public void closeInterpreter() {
        if (!this.initialized) {
            return;
        }
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        RemoteInterpreterService.Client client = null;
        boolean broken = false;
        try {
            client = interpreterProcess.getClient();
            if (client != null) {
                client.close(this.sessionKey, this.className);
            }
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        finally {
            if (client != null) {
                interpreterProcess.releaseClient(client, broken);
            }
            this.initialized = false;
        }
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("st:\n{}", (Object)st);
        }
        Interpreter.FormType form = this.getFormType();
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        RemoteInterpreterService.Client client = null;
        try {
            client = interpreterProcess.getClient();
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        InterpreterContextRunnerPool interpreterContextRunnerPool = interpreterProcess.getInterpreterContextRunnerPool();
        List<InterpreterContextRunner> runners = context.getRunners();
        if (runners != null && runners.size() != 0) {
            String noteId = runners.get(0).getNoteId();
            interpreterContextRunnerPool.clear(noteId);
            interpreterContextRunnerPool.addAll(noteId, runners);
        }
        boolean broken = false;
        try {
            InterpreterResult result;
            GUI currentGUI = context.getGui();
            RemoteInterpreterResult remoteResult = client.interpret(this.sessionKey, this.className, st, this.convert(context));
            Map remoteConfig = (Map)this.gson.fromJson(remoteResult.getConfig(), new TypeToken<Map<String, Object>>(){}.getType());
            context.getConfig().clear();
            context.getConfig().putAll(remoteConfig);
            if (form == Interpreter.FormType.NATIVE) {
                GUI remoteGui = (GUI)this.gson.fromJson(remoteResult.getGui(), GUI.class);
                currentGUI.clear();
                currentGUI.setParams(remoteGui.getParams());
                currentGUI.setForms(remoteGui.getForms());
            } else if (form == Interpreter.FormType.SIMPLE) {
                LinkedHashMap<String, Input> currentForms = currentGUI.getForms();
                Map<String, Object> currentParams = currentGUI.getParams();
                GUI remoteGUI = (GUI)this.gson.fromJson(remoteResult.getGui(), GUI.class);
                LinkedHashMap<String, Input> remoteForms = remoteGUI.getForms();
                Map<String, Object> remoteParams = remoteGUI.getParams();
                currentForms.putAll(remoteForms);
                currentParams.putAll(remoteParams);
            }
            InterpreterResult interpreterResult = result = this.convert(remoteResult);
            return interpreterResult;
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        finally {
            interpreterProcess.releaseClient(client, broken);
        }
    }

    @Override
    public void cancel(InterpreterContext context) {
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        RemoteInterpreterService.Client client = null;
        try {
            client = interpreterProcess.getClient();
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        boolean broken = false;
        try {
            client.cancel(this.sessionKey, this.className, this.convert(context));
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        finally {
            interpreterProcess.releaseClient(client, broken);
        }
    }

    @Override
    public Interpreter.FormType getFormType() {
        this.open();
        if (this.formType != null) {
            return this.formType;
        }
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        RemoteInterpreterService.Client client = null;
        try {
            client = interpreterProcess.getClient();
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        boolean broken = false;
        try {
            Interpreter.FormType formType = this.formType = Interpreter.FormType.valueOf(client.getFormType(this.sessionKey, this.className));
            return formType;
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        finally {
            interpreterProcess.releaseClient(client, broken);
        }
    }

    @Override
    public int getProgress(InterpreterContext context) {
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        if (interpreterProcess == null || !interpreterProcess.isRunning()) {
            return 0;
        }
        RemoteInterpreterService.Client client = null;
        try {
            client = interpreterProcess.getClient();
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        boolean broken = false;
        try {
            int n = client.getProgress(this.sessionKey, this.className, this.convert(context));
            return n;
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        finally {
            interpreterProcess.releaseClient(client, broken);
        }
    }

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor) {
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        RemoteInterpreterService.Client client = null;
        try {
            client = interpreterProcess.getClient();
        }
        catch (Exception e1) {
            throw new InterpreterException(e1);
        }
        boolean broken = false;
        try {
            List<InterpreterCompletion> completion2;
            List<InterpreterCompletion> list = completion2 = client.completion(this.sessionKey, this.className, buf, cursor);
            return list;
        }
        catch (TException e) {
            broken = true;
            throw new InterpreterException(e);
        }
        finally {
            interpreterProcess.releaseClient(client, broken);
        }
    }

    @Override
    public Scheduler getScheduler() {
        int maxConcurrency = this.maxPoolSize;
        RemoteInterpreterProcess interpreterProcess = this.getInterpreterProcess();
        if (interpreterProcess == null) {
            return null;
        }
        return SchedulerFactory.singleton().createOrGetRemoteScheduler(RemoteInterpreter.class.getName() + this.sessionKey + interpreterProcess.hashCode(), this.sessionKey, interpreterProcess, maxConcurrency);
    }

    private String getInterpreterGroupKey(InterpreterGroup interpreterGroup) {
        return interpreterGroup.getId();
    }

    private RemoteInterpreterContext convert(InterpreterContext ic) {
        return new RemoteInterpreterContext(ic.getNoteId(), ic.getParagraphId(), ic.getReplName(), ic.getParagraphTitle(), ic.getParagraphText(), this.gson.toJson((Object)ic.getAuthenticationInfo()), this.gson.toJson(ic.getConfig()), this.gson.toJson((Object)ic.getGui()), this.gson.toJson(ic.getRunners()));
    }

    private InterpreterResult convert(RemoteInterpreterResult result) {
        InterpreterResult r = new InterpreterResult(InterpreterResult.Code.valueOf(result.getCode()));
        for (RemoteInterpreterResultMessage m : result.getMsg()) {
            r.add(InterpreterResult.Type.valueOf(m.getType()), m.getData());
        }
        return r;
    }

    void pushAngularObjectRegistryToRemote(RemoteInterpreterService.Client client) throws TException {
        AngularObjectRegistry angularObjectRegistry = this.getInterpreterGroup().getAngularObjectRegistry();
        if (angularObjectRegistry != null && angularObjectRegistry.getRegistry() != null) {
            Map<String, Map<String, AngularObject>> registry = angularObjectRegistry.getRegistry();
            logger.info("Push local angular object registry from ZeppelinServer to remote interpreter group {}", (Object)this.getInterpreterGroup().getId());
            Type registryType = new TypeToken<Map<String, Map<String, AngularObject>>>(){}.getType();
            Gson gson = new Gson();
            client.angularRegistryPush(gson.toJson(registry, registryType));
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    public void addEnv(Map<String, String> env) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.putAll(env);
    }

    public String getInterpreterRunner() {
        return this.interpreterRunner;
    }
}

