/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.zeppelin.helium.ApplicationEventListener;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventPoller;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcessListener;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterManagedProcess
extends RemoteInterpreterProcess
implements ExecuteResultHandler {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInterpreterManagedProcess.class);
    private final String interpreterRunner;
    private DefaultExecutor executor;
    private ExecuteWatchdog watchdog;
    boolean running = false;
    private int port = -1;
    private final String interpreterDir;
    private final String localRepoDir;
    private Map<String, String> env;

    public RemoteInterpreterManagedProcess(String intpRunner, String intpDir, String localRepoDir, Map<String, String> env, int connectTimeout, RemoteInterpreterProcessListener listener, ApplicationEventListener appListener) {
        super(new RemoteInterpreterEventPoller(listener, appListener), connectTimeout);
        this.interpreterRunner = intpRunner;
        this.env = env;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
    }

    RemoteInterpreterManagedProcess(String intpRunner, String intpDir, String localRepoDir, Map<String, String> env, RemoteInterpreterEventPoller remoteInterpreterEventPoller, int connectTimeout) {
        super(remoteInterpreterEventPoller, connectTimeout);
        this.interpreterRunner = intpRunner;
        this.env = env;
        this.interpreterDir = intpDir;
        this.localRepoDir = localRepoDir;
    }

    @Override
    public String getHost() {
        return "localhost";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start(String userName, Boolean isUserImpersonate) {
        try {
            this.port = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
        }
        catch (IOException e1) {
            throw new InterpreterException(e1);
        }
        CommandLine cmdLine = CommandLine.parse((String)this.interpreterRunner);
        cmdLine.addArgument("-d", false);
        cmdLine.addArgument(this.interpreterDir, false);
        cmdLine.addArgument("-p", false);
        cmdLine.addArgument(Integer.toString(this.port), false);
        if (isUserImpersonate.booleanValue() && !userName.equals("anonymous")) {
            cmdLine.addArgument("-u", false);
            cmdLine.addArgument(userName, false);
        }
        cmdLine.addArgument("-l", false);
        cmdLine.addArgument(this.localRepoDir, false);
        this.executor = new DefaultExecutor();
        ByteArrayOutputStream cmdOut = new ByteArrayOutputStream();
        ProcessLogOutputStream processOutput = new ProcessLogOutputStream(logger);
        processOutput.setOutputStream(cmdOut);
        this.executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)processOutput)));
        this.watchdog = new ExecuteWatchdog(-1L);
        this.executor.setWatchdog(this.watchdog);
        try {
            Map procEnv = EnvironmentUtils.getProcEnvironment();
            procEnv.putAll(this.env);
            logger.info("Run interpreter process {}", (Object)cmdLine);
            this.executor.execute(cmdLine, procEnv, (ExecuteResultHandler)this);
            this.running = true;
        }
        catch (IOException e) {
            this.running = false;
            throw new InterpreterException(e);
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)this.getConnectTimeout()) {
            if (!this.running) {
                try {
                    cmdOut.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new InterpreterException(new String(cmdOut.toByteArray()));
            }
            try {
                if (RemoteInterpreterUtils.checkIfRemoteEndpointAccessible("localhost", this.port)) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.error("Exception in RemoteInterpreterProcess while synchronized reference Thread.sleep", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Remote interpreter not yet accessible at localhost:" + this.port);
            }
        }
        processOutput.setOutputStream(null);
    }

    @Override
    public void stop() {
        if (this.isRunning()) {
            logger.info("kill interpreter process");
            this.watchdog.destroyProcess();
        }
        this.executor = null;
        this.watchdog = null;
        this.running = false;
        logger.info("Remote process terminated");
    }

    public void onProcessComplete(int exitValue) {
        logger.info("Interpreter process exited {}", (Object)exitValue);
        this.running = false;
    }

    public void onProcessFailed(ExecuteException e) {
        logger.info("Interpreter process failed {}", (Throwable)e);
        this.running = false;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    private static class ProcessLogOutputStream
    extends LogOutputStream {
        private Logger logger;
        OutputStream out;

        public ProcessLogOutputStream(Logger logger) {
            this.logger = logger;
        }

        protected void processLine(String s, int i) {
            this.logger.debug(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            super.write(b);
            if (this.out != null) {
                ProcessLogOutputStream processLogOutputStream = this;
                synchronized (processLogOutputStream) {
                    if (this.out != null) {
                        this.out.write(b);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int offset, int len) throws IOException {
            super.write(b, offset, len);
            if (this.out != null) {
                ProcessLogOutputStream processLogOutputStream = this;
                synchronized (processLogOutputStream) {
                    if (this.out != null) {
                        this.out.write(b, offset, len);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOutputStream(OutputStream out) {
            ProcessLogOutputStream processLogOutputStream = this;
            synchronized (processLogOutputStream) {
                this.out = out;
            }
        }
    }
}

