/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterUtils {
    static Logger LOGGER = LoggerFactory.getLogger(RemoteInterpreterUtils.class);

    public static int findRandomAvailablePortOnAllLocalInterfaces() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket(0);){
            port = socket.getLocalPort();
            socket.close();
        }
        return port;
    }

    public static boolean checkIfRemoteEndpointAccessible(String host, int port) {
        try {
            Socket discover = new Socket();
            discover.setSoTimeout(1000);
            discover.connect(new InetSocketAddress(host, port), 1000);
            discover.close();
            return true;
        }
        catch (ConnectException cne) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remote endpoint '" + host + ":" + port + "' is not accessible " + "(might be initializing): " + cne.getMessage());
            }
            return false;
        }
        catch (IOException ioe) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Remote endpoint '" + host + ":" + port + "' is not accessible " + "(might be initializing): " + ioe.getMessage());
            }
            return false;
        }
    }
}

