/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorFactory {
    private static ExecutorFactory _executor;
    private static Long _executorLock;
    Map<String, ExecutorService> executor = new HashMap<String, ExecutorService>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorFactory singleton() {
        if (_executor == null) {
            Long l = _executorLock;
            synchronized (l) {
                if (_executor == null) {
                    _executor = new ExecutorFactory();
                }
            }
        }
        return _executor;
    }

    public ExecutorService getDefaultExecutor() {
        return this.createOrGet("default");
    }

    public ExecutorService createOrGet(String name) {
        return this.createOrGet(name, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService createOrGet(String name, int numThread) {
        Map<String, ExecutorService> map = this.executor;
        synchronized (map) {
            if (!this.executor.containsKey(name)) {
                this.executor.put(name, Executors.newScheduledThreadPool(numThread));
            }
            return this.executor.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String name) {
        Map<String, ExecutorService> map = this.executor;
        synchronized (map) {
            if (this.executor.containsKey(name)) {
                ExecutorService e = this.executor.get(name);
                e.shutdown();
                this.executor.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAll() {
        Map<String, ExecutorService> map = this.executor;
        synchronized (map) {
            for (String name : this.executor.keySet()) {
                this.shutdown(name);
            }
        }
    }

    static {
        _executorLock = new Long(0L);
    }
}

