/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.remote.RemoteEventClient;
import org.apache.zeppelin.interpreter.remote.RemoteEventClientWrapper;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.user.AuthenticationInfo;

public class InterpreterContext {
    private static final ThreadLocal<InterpreterContext> threadIC = new ThreadLocal();
    public InterpreterOutput out;
    private String noteId;
    private String replName;
    private String paragraphTitle;
    private String paragraphId;
    private String paragraphText;
    private AuthenticationInfo authenticationInfo;
    private Map<String, Object> config = new HashMap<String, Object>();
    private GUI gui = new GUI();
    private GUI noteGui = new GUI();
    private AngularObjectRegistry angularObjectRegistry;
    private ResourcePool resourcePool;
    private List<InterpreterContextRunner> runners = new ArrayList<InterpreterContextRunner>();
    private String className;
    private RemoteEventClientWrapper client;
    private RemoteWorksController remoteWorksController;
    private Map<String, Integer> progressMap;

    public static InterpreterContext get() {
        return threadIC.get();
    }

    public static void set(InterpreterContext ic) {
        threadIC.set(ic);
    }

    public static void remove() {
        threadIC.remove();
    }

    public static Builder builder() {
        return new Builder();
    }

    private InterpreterContext() {
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, GUI noteGui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> runners, InterpreterOutput out) {
        this(noteId, paragraphId, replName, paragraphTitle, paragraphText, authenticationInfo, config, gui, noteGui, angularObjectRegistry, resourcePool, runners, out, null, null);
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, GUI noteGui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> runners, InterpreterOutput out, RemoteWorksController remoteWorksController, Map<String, Integer> progressMap) {
        this.noteId = noteId;
        this.paragraphId = paragraphId;
        this.replName = replName;
        this.paragraphTitle = paragraphTitle;
        this.paragraphText = paragraphText;
        this.authenticationInfo = authenticationInfo;
        this.config = config;
        this.gui = gui;
        this.noteGui = noteGui;
        this.angularObjectRegistry = angularObjectRegistry;
        this.resourcePool = resourcePool;
        this.runners = runners;
        this.out = out;
        this.remoteWorksController = remoteWorksController;
        this.progressMap = progressMap;
    }

    public InterpreterContext(String noteId, String paragraphId, String replName, String paragraphTitle, String paragraphText, AuthenticationInfo authenticationInfo, Map<String, Object> config, GUI gui, GUI noteGui, AngularObjectRegistry angularObjectRegistry, ResourcePool resourcePool, List<InterpreterContextRunner> contextRunners, InterpreterOutput output, RemoteWorksController remoteWorksController, RemoteInterpreterEventClient eventClient, Map<String, Integer> progressMap) {
        this(noteId, paragraphId, replName, paragraphTitle, paragraphText, authenticationInfo, config, gui, noteGui, angularObjectRegistry, resourcePool, contextRunners, output, remoteWorksController, progressMap);
        this.client = new RemoteEventClient(eventClient);
    }

    public String getNoteId() {
        return this.noteId;
    }

    public String getReplName() {
        return this.replName;
    }

    public String getParagraphId() {
        return this.paragraphId;
    }

    public String getParagraphText() {
        return this.paragraphText;
    }

    public String getParagraphTitle() {
        return this.paragraphTitle;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public GUI getGui() {
        return this.gui;
    }

    public GUI getNoteGui() {
        return this.noteGui;
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public List<InterpreterContextRunner> getRunners() {
        return this.runners;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public RemoteEventClientWrapper getClient() {
        return this.client;
    }

    public void setClient(RemoteEventClientWrapper client) {
        this.client = client;
    }

    public RemoteWorksController getRemoteWorksController() {
        return this.remoteWorksController;
    }

    public void setRemoteWorksController(RemoteWorksController remoteWorksController) {
        this.remoteWorksController = remoteWorksController;
    }

    public InterpreterOutput out() {
        return this.out;
    }

    public void setProgress(int n) {
        if (this.progressMap != null) {
            n = Math.max(n, 0);
            n = Math.min(n, 100);
            this.progressMap.put(this.paragraphId, new Integer(n));
        }
    }

    public static class Builder {
        private InterpreterContext context = new InterpreterContext();

        public Builder setNoteId(String noteId) {
            this.context.noteId = noteId;
            return this;
        }

        public Builder setParagraphId(String paragraphId) {
            this.context.paragraphId = paragraphId;
            return this;
        }

        public Builder setEventClient(RemoteEventClientWrapper client) {
            this.context.client = client;
            return this;
        }

        public Builder setInterpreterClassName(String intpClassName) {
            this.context.className = intpClassName;
            return this;
        }

        public Builder setReplName(String replName) {
            this.context.replName = replName;
            return this;
        }

        public InterpreterContext build() {
            return this.context;
        }
    }
}

