/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeListener;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutputListener;
import org.apache.zeppelin.interpreter.ResultMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterOutput
extends OutputStream {
    Logger logger = LoggerFactory.getLogger(InterpreterOutput.class);
    private final int NEW_LINE_CHAR = 10;
    private final int LINE_FEED_CHAR = 13;
    private List<InterpreterResultMessageOutput> resultMessageOutputs = new LinkedList<InterpreterResultMessageOutput>();
    private InterpreterResultMessageOutput currentOut;
    private List<String> resourceSearchPaths = Collections.synchronizedList(new LinkedList());
    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final InterpreterOutputListener flushListener;
    private final InterpreterOutputChangeListener changeListener;
    private int size = 0;
    private int lastCRIndex = -1;
    public static int limit = 102400;
    int previousChar = 0;
    boolean startOfTheNewLine = true;
    boolean firstCharIsPercentSign = false;
    boolean truncated = false;

    public InterpreterOutput(InterpreterOutputListener flushListener) {
        this.flushListener = flushListener;
        this.changeListener = null;
        this.clear();
    }

    public InterpreterOutput(InterpreterOutputListener flushListener, InterpreterOutputChangeListener listener) throws IOException {
        this.flushListener = flushListener;
        this.changeListener = listener;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(InterpreterResult.Type type) throws IOException {
        InterpreterResultMessageOutput out = null;
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            int index = this.resultMessageOutputs.size();
            InterpreterResultMessageOutputListener listener = this.createInterpreterResultMessageOutputListener(index);
            out = this.changeListener == null ? new InterpreterResultMessageOutput(type, listener) : new InterpreterResultMessageOutput(type, listener, this.changeListener);
            out.setResourceSearchPaths(this.resourceSearchPaths);
            this.buffer.reset();
            this.size = 0;
            this.lastCRIndex = -1;
            if (this.currentOut != null) {
                this.currentOut.flush();
            }
            this.resultMessageOutputs.add(out);
            this.currentOut = out;
        }
    }

    public InterpreterResultMessageOutputListener createInterpreterResultMessageOutputListener(final int index) {
        return new InterpreterResultMessageOutputListener(){
            final int idx;
            {
                this.idx = index;
            }

            @Override
            public void onAppend(InterpreterResultMessageOutput out, byte[] line) {
                if (InterpreterOutput.this.flushListener != null) {
                    InterpreterOutput.this.flushListener.onAppend(this.idx, out, line);
                }
            }

            @Override
            public void onUpdate(InterpreterResultMessageOutput out) {
                if (InterpreterOutput.this.flushListener != null) {
                    InterpreterOutput.this.flushListener.onUpdate(this.idx, out);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResultMessageOutput getCurrentOutput() {
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            return this.currentOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterpreterResultMessageOutput getOutputAt(int index) {
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            return this.resultMessageOutputs.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            return this.resultMessageOutputs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.size = 0;
        this.lastCRIndex = -1;
        this.truncated = false;
        this.buffer.reset();
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            for (InterpreterResultMessageOutput out : this.resultMessageOutputs) {
                out.clear();
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
            this.resultMessageOutputs.clear();
            this.currentOut = null;
            this.startOfTheNewLine = true;
            this.firstCharIsPercentSign = false;
            this.updateAllResultMessages();
        }
    }

    private void updateAllResultMessages() {
        if (this.flushListener != null) {
            this.flushListener.onUpdateAll(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        if (this.truncated) {
            return;
        }
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            InterpreterResult.Type type;
            this.currentOut = this.getCurrentOutput();
            if (++this.size > limit && b == 10 && this.currentOut != null && ((type = this.currentOut.getType()) == InterpreterResult.Type.TEXT || type == InterpreterResult.Type.TABLE)) {
                this.setType(InterpreterResult.Type.HTML);
                this.getCurrentOutput().write(ResultMessages.getExceedsLimitSizeMessage(limit, "ZEPPELIN_INTERPRETER_OUTPUT_LIMIT").getData().getBytes());
                this.truncated = true;
                return;
            }
            if (b == 13) {
                if (this.lastCRIndex == -1) {
                    this.lastCRIndex = this.size;
                }
                this.size = this.lastCRIndex;
            }
            if (this.startOfTheNewLine) {
                if (b == 37) {
                    this.startOfTheNewLine = false;
                    this.firstCharIsPercentSign = true;
                    this.buffer.write(b);
                    this.previousChar = b;
                    return;
                }
                if (b != 10) {
                    this.startOfTheNewLine = false;
                }
            }
            if (b == 10) {
                if (this.currentOut != null && this.currentOut.getType() == InterpreterResult.Type.TABLE) {
                    if (this.previousChar == 10) {
                        this.startOfTheNewLine = true;
                        return;
                    }
                } else {
                    this.startOfTheNewLine = true;
                }
            }
            boolean flushBuffer = false;
            if (this.firstCharIsPercentSign) {
                if (b == 32 || b == 10 || b == 9) {
                    this.firstCharIsPercentSign = false;
                    String displaySystem = this.buffer.toString();
                    for (InterpreterResult.Type type2 : InterpreterResult.Type.values()) {
                        if (!displaySystem.equals('%' + type2.name().toLowerCase())) continue;
                        this.setType(type2);
                        this.previousChar = b;
                        return;
                    }
                    flushBuffer = true;
                } else {
                    this.buffer.write(b);
                    this.previousChar = b;
                    return;
                }
            }
            InterpreterResultMessageOutput out = this.getCurrentOutputForWriting();
            if (flushBuffer) {
                out.write(this.buffer.toByteArray());
                this.buffer.reset();
            }
            out.write(b);
            this.previousChar = b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterpreterResultMessageOutput getCurrentOutputForWriting() throws IOException {
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            InterpreterResultMessageOutput out = this.getCurrentOutput();
            if (out == null) {
                this.setType(InterpreterResult.Type.TEXT);
                out = this.getCurrentOutput();
            }
            return out;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < len; ++i) {
            this.write(b[i]);
        }
    }

    public void write(File file) throws IOException {
        InterpreterResultMessageOutput out = this.getCurrentOutputForWriting();
        out.write(file);
    }

    public void write(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void write(URL url) throws IOException {
        InterpreterResultMessageOutput out = this.getCurrentOutputForWriting();
        out.write(url);
    }

    public void addResourceSearchPath(String path) {
        this.resourceSearchPaths.add(path);
    }

    public void writeResource(String resourceName) throws IOException {
        InterpreterResultMessageOutput out = this.getCurrentOutputForWriting();
        out.writeResource(resourceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InterpreterResultMessage> toInterpreterResultMessage() throws IOException {
        LinkedList<InterpreterResultMessage> list = new LinkedList<InterpreterResultMessage>();
        List<InterpreterResultMessageOutput> list2 = this.resultMessageOutputs;
        synchronized (list2) {
            for (InterpreterResultMessageOutput out : this.resultMessageOutputs) {
                list.add(out.toInterpreterResultMessage());
            }
        }
        return list;
    }

    @Override
    public void flush() throws IOException {
        InterpreterResultMessageOutput out = this.getCurrentOutput();
        if (out != null) {
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            for (InterpreterResultMessageOutput m : this.resultMessageOutputs) {
                out.write(m.toByteArray());
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<InterpreterResultMessageOutput> list = this.resultMessageOutputs;
        synchronized (list) {
            for (InterpreterResultMessageOutput out : this.resultMessageOutputs) {
                out.close();
            }
        }
    }
}

