/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.remote;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.thrift.TException;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.zeppelin.dep.DependencyResolver;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectRegistryListener;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.helium.Application;
import org.apache.zeppelin.helium.ApplicationContext;
import org.apache.zeppelin.helium.ApplicationException;
import org.apache.zeppelin.helium.ApplicationLoader;
import org.apache.zeppelin.helium.HeliumAppAngularObjectRegistry;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookListener;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterOutputListener;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.interpreter.InterpreterResultMessageOutput;
import org.apache.zeppelin.interpreter.LazyOpenInterpreter;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.RemoteZeppelinServerResource;
import org.apache.zeppelin.interpreter.remote.InvokeResourceMethodEventMessage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterContextRunner;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterEventClient;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.CallbackInfo;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.thrift.RemoteApplicationResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterContext;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterEvent;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResult;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterResultMessage;
import org.apache.zeppelin.interpreter.thrift.RemoteInterpreterService;
import org.apache.zeppelin.interpreter.thrift.ZeppelinServerResourceParagraphRunner;
import org.apache.zeppelin.resource.DistributedResourcePool;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.apache.zeppelin.resource.WellKnownResourceName;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteInterpreterServer
extends Thread
implements RemoteInterpreterService.Iface,
AngularObjectRegistryListener {
    private static Logger logger = LoggerFactory.getLogger(RemoteInterpreterServer.class);
    InterpreterGroup interpreterGroup;
    AngularObjectRegistry angularObjectRegistry;
    InterpreterHookRegistry hookRegistry;
    DistributedResourcePool resourcePool;
    private ApplicationLoader appLoader;
    Gson gson = new Gson();
    RemoteInterpreterService.Processor<RemoteInterpreterServer> processor;
    private String callbackHost;
    private int callbackPort;
    private String host;
    private int port;
    private TThreadPoolServer server;
    RemoteInterpreterEventClient eventClient = new RemoteInterpreterEventClient();
    private DependencyResolver depLoader;
    private final Map<String, RunningApplication> runningApplications = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> remoteWorksResponsePool;
    private ZeppelinRemoteWorksController remoteWorksController;
    private final long DEFAULT_SHUTDOWN_TIMEOUT = 2000L;
    private ConcurrentMap<String, Integer> progressMap = new ConcurrentHashMap<String, Integer>();
    private boolean isTest;

    public RemoteInterpreterServer(String callbackHost, int callbackPort, String portRange) throws IOException, TTransportException {
        this(callbackHost, callbackPort, portRange, false);
    }

    public RemoteInterpreterServer(String callbackHost, int callbackPort, String portRange, boolean isTest) throws TTransportException, IOException {
        TServerSocket serverTransport;
        if (null != callbackHost) {
            this.callbackHost = callbackHost;
            this.callbackPort = callbackPort;
        } else {
            this.port = callbackPort;
        }
        this.isTest = isTest;
        this.processor = new RemoteInterpreterService.Processor<RemoteInterpreterServer>(this);
        if (null == callbackHost) {
            serverTransport = new TServerSocket(callbackPort);
        } else {
            serverTransport = RemoteInterpreterUtils.createTServerSocket(portRange);
            this.port = serverTransport.getServerSocket().getLocalPort();
            this.host = RemoteInterpreterUtils.findAvailableHostAddress();
            logger.info("Launching ThriftServer at " + this.host + ":" + this.port);
        }
        this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(this.processor));
        logger.info("Starting remote interpreter server on port {}", (Object)this.port);
        this.remoteWorksResponsePool = Collections.synchronizedMap(new HashMap());
        this.remoteWorksController = new ZeppelinRemoteWorksController(this, this.remoteWorksResponsePool);
    }

    @Override
    public void run() {
        if (null != this.callbackHost && !this.isTest) {
            new Thread(new Runnable(){
                boolean interrupted = false;

                @Override
                public void run() {
                    while (!this.interrupted && !RemoteInterpreterServer.this.server.isServing()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            this.interrupted = true;
                        }
                    }
                    if (!this.interrupted) {
                        CallbackInfo callbackInfo = new CallbackInfo(RemoteInterpreterServer.this.host, RemoteInterpreterServer.this.port);
                        try {
                            RemoteInterpreterUtils.registerInterpreter(RemoteInterpreterServer.this.callbackHost, RemoteInterpreterServer.this.callbackPort, callbackInfo);
                        }
                        catch (TException e) {
                            logger.error("Error while registering interpreter: {}", (Object)callbackInfo, (Object)e);
                            try {
                                RemoteInterpreterServer.this.shutdown();
                            }
                            catch (TException e1) {
                                logger.warn("Exception occurs while shutting down", (Throwable)e1);
                            }
                        }
                    }
                }
            }).start();
        }
        logger.info("Starting remote interpreter server on port {}", (Object)this.port);
        this.server.serve();
    }

    @Override
    public void shutdown() throws TException {
        logger.info("Shutting down...");
        this.eventClient.waitForEventQueueBecomesEmpty(2000L);
        if (this.interpreterGroup != null) {
            for (List<Interpreter> session : this.interpreterGroup.values()) {
                for (Interpreter interpreter : session) {
                    try {
                        interpreter.close();
                    }
                    catch (InterpreterException e) {
                        logger.warn("Fail to close interpreter", (Throwable)e);
                    }
                }
            }
        }
        this.server.stop();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 2000L && this.server.isServing()) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                logger.info("Exception in RemoteInterpreterServer while shutdown, Thread.sleep", (Throwable)e);
            }
        }
        if (this.server.isServing()) {
            System.exit(0);
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean isRunning() {
        if (this.server == null) {
            return false;
        }
        return this.server.isServing();
    }

    public static void main(String[] args) throws TTransportException, InterruptedException, IOException {
        Class<RemoteInterpreterServer> klass = RemoteInterpreterServer.class;
        URL location = klass.getResource('/' + klass.getName().replace('.', '/') + ".class");
        logger.info("URL:" + location);
        String callbackHost = null;
        int port = 29914;
        String portRange = ":";
        if (args.length > 0) {
            callbackHost = args[0];
            port = Integer.parseInt(args[1]);
            if (args.length > 2) {
                portRange = args[2];
            }
        }
        RemoteInterpreterServer remoteInterpreterServer = new RemoteInterpreterServer(callbackHost, port, portRange);
        remoteInterpreterServer.start();
        remoteInterpreterServer.join();
        System.exit(0);
    }

    @Override
    public void createInterpreter(String interpreterGroupId, String sessionId, String className, Map<String, String> properties, String userName) throws TException {
        if (this.interpreterGroup == null) {
            this.interpreterGroup = new InterpreterGroup(interpreterGroupId);
            this.angularObjectRegistry = new AngularObjectRegistry(this.interpreterGroup.getId(), this);
            this.hookRegistry = new InterpreterHookRegistry();
            this.resourcePool = new DistributedResourcePool(this.interpreterGroup.getId(), this.eventClient);
            this.interpreterGroup.setInterpreterHookRegistry(this.hookRegistry);
            this.interpreterGroup.setAngularObjectRegistry(this.angularObjectRegistry);
            this.interpreterGroup.setResourcePool(this.resourcePool);
            String localRepoPath = properties.get("zeppelin.interpreter.localRepo");
            if (properties.containsKey("zeppelin.interpreter.output.limit")) {
                InterpreterOutput.limit = Integer.parseInt(properties.get("zeppelin.interpreter.output.limit"));
            }
            this.depLoader = new DependencyResolver(localRepoPath);
            this.appLoader = new ApplicationLoader(this.resourcePool, this.depLoader);
        }
        try {
            Class<?> replClass = Class.forName(className);
            Properties p = new Properties();
            p.putAll(properties);
            this.setSystemProperty(p);
            Constructor<?> constructor = replClass.getConstructor(Properties.class);
            Interpreter repl = (Interpreter)constructor.newInstance(p);
            repl.setClassloaderUrls(new URL[0]);
            logger.info("Instantiate interpreter {}", (Object)className);
            repl.setInterpreterGroup(this.interpreterGroup);
            repl.setUserName(userName);
            this.interpreterGroup.addInterpreterToSession(new LazyOpenInterpreter(repl), sessionId);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error(e.toString(), (Throwable)e);
            throw new TException((Throwable)e);
        }
    }

    protected InterpreterGroup getInterpreterGroup() {
        return this.interpreterGroup;
    }

    protected ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    protected RemoteInterpreterEventClient getEventClient() {
        return this.eventClient;
    }

    private void setSystemProperty(Properties properties) {
        for (Object key : properties.keySet()) {
            if (RemoteInterpreterUtils.isEnvString((String)key)) continue;
            String value = properties.getProperty((String)key);
            if (value == null || value.isEmpty()) {
                System.clearProperty((String)key);
                continue;
            }
            System.setProperty((String)key, properties.getProperty((String)key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Interpreter getInterpreter(String sessionId, String className) throws TException {
        if (this.interpreterGroup == null) {
            throw new TException((Throwable)new InterpreterException("Interpreter instance " + className + " not created"));
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List<Interpreter> interpreters = this.interpreterGroup.get(sessionId);
            if (interpreters == null) {
                throw new TException((Throwable)new InterpreterException("Interpreter " + className + " not initialized"));
            }
            for (Interpreter inp : interpreters) {
                if (!inp.getClassName().equals(className)) continue;
                return inp;
            }
        }
        throw new TException((Throwable)new InterpreterException("Interpreter instance " + className + " not found"));
    }

    @Override
    public void open(String sessionId, String className) throws TException {
        logger.info(String.format("Open Interpreter %s for session %s ", className, sessionId));
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            intp.open();
        }
        catch (InterpreterException e) {
            throw new TException("Fail to open interpreter", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String sessionId, String className) throws TException {
        List<Interpreter> interpreters;
        for (String string : this.runningApplications.keySet()) {
            RunningApplication appInfo = this.runningApplications.get(string);
            if (!appInfo.noteId.equals(sessionId) && !sessionId.equals("shared_session")) continue;
            try {
                logger.info("Unload App {} ", (Object)appInfo.pkg.getName());
                appInfo.app.unload();
                this.eventClient.onAppStatusUpdate(appInfo.noteId, appInfo.paragraphId, string, "UNLOADED");
            }
            catch (ApplicationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            interpreters = this.interpreterGroup.get(sessionId);
        }
        if (interpreters != null) {
            Iterator<Interpreter> iterator = interpreters.iterator();
            while (iterator.hasNext()) {
                Interpreter inp = iterator.next();
                if (!inp.getClassName().equals(className)) continue;
                try {
                    inp.close();
                }
                catch (InterpreterException e) {
                    logger.warn("Fail to close interpreter", (Throwable)e);
                }
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteInterpreterResult interpret(String noteId, String className, String st, RemoteInterpreterContext interpreterContext) throws TException {
        if (logger.isDebugEnabled()) {
            logger.debug("st:\n{}", (Object)st);
        }
        Interpreter intp = this.getInterpreter(noteId, className);
        InterpreterContext context = this.convert(interpreterContext);
        context.setClassName(intp.getClassName());
        Scheduler scheduler = intp.getScheduler();
        InterpretJobListener jobListener = new InterpretJobListener();
        InterpretJob job = new InterpretJob(interpreterContext.getParagraphId(), "remoteInterpretJob_" + System.currentTimeMillis(), jobListener, 500L, intp, st, context);
        scheduler.submit(job);
        while (!job.isTerminated()) {
            InterpretJobListener interpretJobListener = jobListener;
            synchronized (interpretJobListener) {
                try {
                    jobListener.wait(1000L);
                }
                catch (InterruptedException e) {
                    logger.info("Exception in RemoteInterpreterServer while interpret, jobListener.wait", (Throwable)e);
                }
            }
        }
        this.progressMap.remove(interpreterContext.getParagraphId());
        InterpreterResult result = (InterpreterResult)job.getReturn();
        if (result == null) {
            result = new InterpreterResult(InterpreterResult.Code.KEEP_PREVIOUS_RESULT);
        }
        return this.convert(result, context.getConfig(), context.getGui(), context.getNoteGui());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReceivedZeppelinResource(String responseJson) throws TException {
        block7: {
            RemoteZeppelinServerResource response = RemoteZeppelinServerResource.fromJson(responseJson);
            if (response == null) {
                throw new TException("Bad response for remote resource");
            }
            if (response.getResourceType() != RemoteZeppelinServerResource.Type.PARAGRAPH_RUNNERS) break block7;
            LinkedList<ParagraphRunner> intpContextRunners = new LinkedList<ParagraphRunner>();
            List remoteRunnersMap = (List)response.getData();
            String noteId = null;
            String paragraphId = null;
            for (Map runnerItem : remoteRunnersMap) {
                noteId = (String)runnerItem.get("noteId");
                paragraphId = (String)runnerItem.get("paragraphId");
                intpContextRunners.add(new ParagraphRunner(this, noteId, paragraphId));
            }
            Map<String, Object> map = this.remoteWorksResponsePool;
            synchronized (map) {
                this.remoteWorksResponsePool.put(response.getOwnerKey(), intpContextRunners);
            }
        }
    }

    @Override
    public void cancel(String noteId, String className, RemoteInterpreterContext interpreterContext) throws TException {
        logger.info("cancel {} {}", (Object)className, (Object)interpreterContext.getParagraphId());
        Interpreter intp = this.getInterpreter(noteId, className);
        String jobId = interpreterContext.getParagraphId();
        Job job = intp.getScheduler().removeFromWaitingQueue(jobId);
        if (job != null) {
            job.setStatus(Job.Status.ABORT);
        } else {
            try {
                intp.cancel(this.convert(interpreterContext, null));
            }
            catch (InterpreterException e) {
                throw new TException("Fail to cancel", (Throwable)e);
            }
        }
    }

    @Override
    public int getProgress(String sessionId, String className, RemoteInterpreterContext interpreterContext) throws TException {
        Integer manuallyProvidedProgress = (Integer)this.progressMap.get(interpreterContext.getParagraphId());
        if (manuallyProvidedProgress != null) {
            return manuallyProvidedProgress;
        }
        Interpreter intp = this.getInterpreter(sessionId, className);
        if (intp == null) {
            throw new TException(String.format(className, sessionId));
        }
        try {
            return intp.getProgress(this.convert(interpreterContext, null));
        }
        catch (InterpreterException e) {
            throw new TException("Fail to getProgress", (Throwable)e);
        }
    }

    @Override
    public String getFormType(String sessionId, String className) throws TException {
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            return intp.getFormType().toString();
        }
        catch (InterpreterException e) {
            throw new TException((Throwable)e);
        }
    }

    @Override
    public List<InterpreterCompletion> completion(String sessionId, String className, String buf, int cursor, RemoteInterpreterContext remoteInterpreterContext) throws TException {
        Interpreter intp = this.getInterpreter(sessionId, className);
        try {
            return intp.completion(buf, cursor, this.convert(remoteInterpreterContext, null));
        }
        catch (InterpreterException e) {
            throw new TException("Fail to get completion", (Throwable)e);
        }
    }

    private InterpreterContext convert(RemoteInterpreterContext ric) {
        return this.convert(ric, this.createInterpreterOutput(ric.getNoteId(), ric.getParagraphId()));
    }

    private InterpreterContext convert(RemoteInterpreterContext ric, InterpreterOutput output) {
        LinkedList<InterpreterContextRunner> contextRunners = new LinkedList<InterpreterContextRunner>();
        List runners = (List)this.gson.fromJson(ric.getRunners(), new TypeToken<List<RemoteInterpreterContextRunner>>(){}.getType());
        for (InterpreterContextRunner r : runners) {
            contextRunners.add(new ParagraphRunner(this, r.getNoteId(), r.getParagraphId()));
        }
        return new InterpreterContext(ric.getNoteId(), ric.getParagraphId(), ric.getReplName(), ric.getParagraphTitle(), ric.getParagraphText(), AuthenticationInfo.fromJson(ric.getAuthenticationInfo()), (Map)this.gson.fromJson(ric.getConfig(), new TypeToken<Map<String, Object>>(){}.getType()), GUI.fromJson(ric.getGui()), GUI.fromJson(ric.getNoteGui()), this.interpreterGroup.getAngularObjectRegistry(), this.interpreterGroup.getResourcePool(), contextRunners, output, this.remoteWorksController, this.eventClient, this.progressMap);
    }

    protected InterpreterOutput createInterpreterOutput(final String noteId, final String paragraphId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
                try {
                    RemoteInterpreterServer.this.eventClient.onInterpreterOutputUpdateAll(noteId, paragraphId, out.toInterpreterResultMessage());
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                String output = new String(line);
                logger.debug("Output Append: {}", (Object)output);
                RemoteInterpreterServer.this.eventClient.onInterpreterOutputAppend(noteId, paragraphId, index, output);
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    String output = new String(out.toByteArray());
                    logger.debug("Output Update: {}", (Object)output);
                    RemoteInterpreterServer.this.eventClient.onInterpreterOutputUpdate(noteId, paragraphId, index, out.getType(), output);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private RemoteInterpreterResult convert(InterpreterResult result, Map<String, Object> config, GUI gui, GUI noteGui) {
        LinkedList<RemoteInterpreterResultMessage> msg = new LinkedList<RemoteInterpreterResultMessage>();
        for (InterpreterResultMessage m : result.message()) {
            msg.add(new RemoteInterpreterResultMessage(m.getType().name(), m.getData()));
        }
        return new RemoteInterpreterResult(result.code().name(), msg, this.gson.toJson(config), gui.toJson(), noteGui.toJson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getStatus(String sessionId, String jobId) throws TException {
        if (this.interpreterGroup == null) {
            return Job.Status.UNKNOWN.name();
        }
        InterpreterGroup interpreterGroup = this.interpreterGroup;
        synchronized (interpreterGroup) {
            List<Interpreter> interpreters = this.interpreterGroup.get(sessionId);
            if (interpreters == null) {
                return Job.Status.UNKNOWN.name();
            }
            for (Interpreter intp : interpreters) {
                for (Job job : intp.getScheduler().getJobsRunning()) {
                    if (!jobId.equals(job.getId())) continue;
                    return job.getStatus().name();
                }
                for (Job job : intp.getScheduler().getJobsWaiting()) {
                    if (!jobId.equals(job.getId())) continue;
                    return job.getStatus().name();
                }
            }
        }
        return Job.Status.UNKNOWN.name();
    }

    @Override
    public void onAdd(String interpreterGroupId, AngularObject object) {
        this.eventClient.angularObjectAdd(object);
    }

    @Override
    public void onUpdate(String interpreterGroupId, AngularObject object) {
        this.eventClient.angularObjectUpdate(object);
    }

    @Override
    public void onRemove(String interpreterGroupId, String name, String noteId, String paragraphId) {
        this.eventClient.angularObjectRemove(name, noteId, paragraphId);
    }

    @Override
    public RemoteInterpreterEvent getEvent() throws TException {
        return this.eventClient.pollEvent();
    }

    @Override
    public void angularObjectUpdate(String name, String noteId, String paragraphId, String object) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao == null) {
            logger.debug("Angular object {} not exists", (Object)name);
            return;
        }
        if (object == null) {
            ao.set(null, false);
            return;
        }
        Object oldObject = ao.get();
        Object value = null;
        if (oldObject != null) {
            try {
                value = this.gson.fromJson(object, oldObject.getClass());
                ao.set(value, false);
                return;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (value == null) {
            try {
                value = this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        ao.set(value, false);
    }

    @Override
    public void angularObjectAdd(String name, String noteId, String paragraphId, String object) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        if (ao != null) {
            this.angularObjectUpdate(name, noteId, paragraphId, object);
            return;
        }
        Object value = null;
        try {
            value = this.gson.fromJson(object, new TypeToken<Map<String, Object>>(){}.getType());
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (value == null) {
            value = this.gson.fromJson(object, String.class);
        }
        registry.add(name, value, noteId, paragraphId, false);
    }

    @Override
    public void angularObjectRemove(String name, String noteId, String paragraphId) throws TException {
        AngularObjectRegistry registry = this.interpreterGroup.getAngularObjectRegistry();
        registry.remove(name, noteId, paragraphId, false);
    }

    @Override
    public void resourcePoolResponseGetAll(List<String> resources) throws TException {
        this.eventClient.putResponseGetAllResources(resources);
    }

    @Override
    public void resourceResponseGet(String resourceId, ByteBuffer object) throws TException {
        this.eventClient.putResponseGetResource(resourceId, object);
    }

    @Override
    public List<String> resourcePoolGetAll() throws TException {
        logger.debug("Request getAll from ZeppelinServer");
        LinkedList<String> result = new LinkedList<String>();
        if (this.resourcePool == null) {
            return result;
        }
        ResourceSet resourceSet = this.resourcePool.getAll(false);
        for (Resource r : resourceSet) {
            result.add(r.toJson());
        }
        return result;
    }

    @Override
    public boolean resourceRemove(String noteId, String paragraphId, String resourceName) throws TException {
        Resource resource = this.resourcePool.remove(noteId, paragraphId, resourceName);
        return resource != null;
    }

    @Override
    public ByteBuffer resourceGet(String noteId, String paragraphId, String resourceName) throws TException {
        logger.debug("Request resourceGet {} from ZeppelinServer", (Object)resourceName);
        Resource resource = this.resourcePool.get(noteId, paragraphId, resourceName, false);
        if (resource == null || resource.get() == null || !resource.isSerializable()) {
            return ByteBuffer.allocate(0);
        }
        try {
            return Resource.serializeObject(resource.get());
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ByteBuffer.allocate(0);
        }
    }

    @Override
    public ByteBuffer resourceInvokeMethod(String noteId, String paragraphId, String resourceName, String invokeMessage) {
        InvokeResourceMethodEventMessage message = InvokeResourceMethodEventMessage.fromJson(invokeMessage);
        Resource resource = this.resourcePool.get(noteId, paragraphId, resourceName, false);
        if (resource == null || resource.get() == null) {
            return ByteBuffer.allocate(0);
        }
        try {
            Object o = resource.get();
            Method method = o.getClass().getMethod(message.methodName, message.getParamTypes());
            Object ret = method.invoke(o, message.params);
            if (message.shouldPutResultIntoResourcePool()) {
                this.resourcePool.put(noteId, paragraphId, message.returnResourceName, ret);
                return ByteBuffer.allocate(0);
            }
            ByteBuffer serialized = Resource.serializeObject(ret);
            if (serialized == null) {
                return ByteBuffer.allocate(0);
            }
            return serialized;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return ByteBuffer.allocate(0);
        }
    }

    @Override
    public void resourceResponseInvokeMethod(String invokeResourceMethodEventMessage, ByteBuffer object) throws TException {
        InvokeResourceMethodEventMessage message = InvokeResourceMethodEventMessage.fromJson(invokeResourceMethodEventMessage);
        if (message.shouldPutResultIntoResourcePool()) {
            Resource resource = this.resourcePool.get(message.resourceId.getNoteId(), message.resourceId.getParagraphId(), message.returnResourceName, true);
            this.eventClient.putResponseInvokeMethod(message, resource);
        } else {
            this.eventClient.putResponseInvokeMethod(message, object);
        }
    }

    @Override
    public void angularRegistryPush(String registryAsString) throws TException {
        try {
            Map deserializedRegistry = (Map)this.gson.fromJson(registryAsString, new TypeToken<Map<String, Map<String, AngularObject>>>(){}.getType());
            this.interpreterGroup.getAngularObjectRegistry().setRegistry(deserializedRegistry);
        }
        catch (Exception e) {
            logger.info("Exception in RemoteInterpreterServer while angularRegistryPush, nolock", (Throwable)e);
        }
    }

    protected InterpreterOutput createAppOutput(final String noteId, final String paragraphId, final String appId) {
        return new InterpreterOutput(new InterpreterOutputListener(){

            @Override
            public void onUpdateAll(InterpreterOutput out) {
            }

            @Override
            public void onAppend(int index, InterpreterResultMessageOutput out, byte[] line) {
                RemoteInterpreterServer.this.eventClient.onAppOutputAppend(noteId, paragraphId, index, appId, new String(line));
            }

            @Override
            public void onUpdate(int index, InterpreterResultMessageOutput out) {
                try {
                    RemoteInterpreterServer.this.eventClient.onAppOutputUpdate(noteId, paragraphId, index, appId, out.getType(), new String(out.toByteArray()));
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private ApplicationContext getApplicationContext(HeliumPackage packageInfo, String noteId, String paragraphId, String applicationInstanceId) {
        InterpreterOutput out = this.createAppOutput(noteId, paragraphId, applicationInstanceId);
        return new ApplicationContext(noteId, paragraphId, applicationInstanceId, new HeliumAppAngularObjectRegistry(this.angularObjectRegistry, noteId, applicationInstanceId), out);
    }

    @Override
    public RemoteApplicationResult loadApplication(String applicationInstanceId, String packageInfo, String noteId, String paragraphId) throws TException {
        if (this.runningApplications.containsKey(applicationInstanceId)) {
            logger.warn("Application instance {} is already running");
            return new RemoteApplicationResult(true, "");
        }
        HeliumPackage pkgInfo = HeliumPackage.fromJson(packageInfo);
        ApplicationContext context = this.getApplicationContext(pkgInfo, noteId, paragraphId, applicationInstanceId);
        try {
            Application app = null;
            logger.info("Loading application {}({}), artifact={}, className={} into note={}, paragraph={}", new Object[]{pkgInfo.getName(), applicationInstanceId, pkgInfo.getArtifact(), pkgInfo.getClassName(), noteId, paragraphId});
            app = this.appLoader.load(pkgInfo, context);
            this.runningApplications.put(applicationInstanceId, new RunningApplication(pkgInfo, app, noteId, paragraphId));
            return new RemoteApplicationResult(true, "");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    @Override
    public RemoteApplicationResult unloadApplication(String applicationInstanceId) throws TException {
        RunningApplication runningApplication = this.runningApplications.remove(applicationInstanceId);
        if (runningApplication != null) {
            try {
                logger.info("Unloading application {}", (Object)applicationInstanceId);
                runningApplication.app.unload();
            }
            catch (ApplicationException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return new RemoteApplicationResult(false, e.getMessage());
            }
        }
        return new RemoteApplicationResult(true, "");
    }

    @Override
    public RemoteApplicationResult runApplication(String applicationInstanceId) throws TException {
        logger.info("run application {}", (Object)applicationInstanceId);
        RunningApplication runningApp = this.runningApplications.get(applicationInstanceId);
        if (runningApp == null) {
            logger.error("Application instance {} not exists", (Object)applicationInstanceId);
            return new RemoteApplicationResult(false, "Application instance does not exists");
        }
        ApplicationContext context = runningApp.app.context();
        try {
            context.out.clear();
            context.out.setType(InterpreterResult.Type.ANGULAR);
            ResourceSet resource = this.appLoader.findRequiredResourceSet(runningApp.pkg.getResources(), context.getNoteId(), context.getParagraphId());
            for (Resource res : resource) {
                System.err.println("Resource " + res.get());
            }
            runningApp.app.run(resource);
            context.out.flush();
            InterpreterResultMessageOutput out = context.out.getOutputAt(0);
            this.eventClient.onAppOutputUpdate(context.getNoteId(), context.getParagraphId(), 0, applicationInstanceId, out.getType(), new String(out.toByteArray()));
            return new RemoteApplicationResult(true, "");
        }
        catch (IOException | ApplicationException e) {
            return new RemoteApplicationResult(false, e.getMessage());
        }
    }

    private static class RunningApplication {
        public final Application app;
        public final HeliumPackage pkg;
        public final String noteId;
        public final String paragraphId;

        public RunningApplication(HeliumPackage pkg, Application app, String noteId, String paragraphId) {
            this.app = app;
            this.pkg = pkg;
            this.noteId = noteId;
            this.paragraphId = paragraphId;
        }
    }

    static class ZeppelinRemoteWorksController
    implements RemoteWorksController {
        Logger logger = LoggerFactory.getLogger(ZeppelinRemoteWorksController.class);
        private final long DEFAULT_TIMEOUT_VALUE = 300000L;
        private final Map<String, Object> remoteWorksResponsePool;
        private RemoteInterpreterServer server;

        public ZeppelinRemoteWorksController(RemoteInterpreterServer server, Map<String, Object> remoteWorksResponsePool) {
            this.remoteWorksResponsePool = remoteWorksResponsePool;
            this.server = server;
        }

        public String generateOwnerKey() {
            String hashKeyText = new String("ownerKey" + System.currentTimeMillis());
            String hashKey = String.valueOf(hashKeyText.hashCode());
            return hashKey;
        }

        public boolean waitForEvent(String eventOwnerKey) throws InterruptedException {
            return this.waitForEvent(eventOwnerKey, 300000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForEvent(String eventOwnerKey, long timeout) throws InterruptedException {
            boolean wasGetData = false;
            long now = System.currentTimeMillis();
            long endTime = System.currentTimeMillis() + timeout;
            while (endTime >= now) {
                Map<String, Object> map = this.remoteWorksResponsePool;
                synchronized (map) {
                    wasGetData = this.remoteWorksResponsePool.containsKey(eventOwnerKey);
                }
                if (wasGetData) break;
                now = System.currentTimeMillis();
                Thread.sleep(500L);
            }
            return wasGetData;
        }

        @Override
        public List<InterpreterContextRunner> getRemoteContextRunner(String noteId) {
            return this.getRemoteContextRunner(noteId, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<InterpreterContextRunner> getRemoteContextRunner(String noteId, String paragraphID) {
            List runners = null;
            String ownerKey = this.generateOwnerKey();
            ZeppelinServerResourceParagraphRunner resource = new ZeppelinServerResourceParagraphRunner();
            resource.setNoteId(noteId);
            resource.setParagraphId(paragraphID);
            this.server.eventClient.getZeppelinServerNoteRunner(ownerKey, resource);
            try {
                this.waitForEvent(ownerKey);
            }
            catch (Exception e) {
                return new LinkedList<InterpreterContextRunner>();
            }
            Map<String, Object> map = this.remoteWorksResponsePool;
            synchronized (map) {
                runners = (List)this.remoteWorksResponsePool.get(ownerKey);
                this.remoteWorksResponsePool.remove(ownerKey);
            }
            return runners;
        }
    }

    static class ParagraphRunner
    extends InterpreterContextRunner {
        Logger logger = LoggerFactory.getLogger(ParagraphRunner.class);
        private transient RemoteInterpreterServer server;

        public ParagraphRunner(RemoteInterpreterServer server, String noteId, String paragraphId) {
            super(noteId, paragraphId);
            this.server = server;
        }

        @Override
        public void run() {
            this.server.eventClient.run(this);
        }
    }

    public static class InterpretJob
    extends Job {
        private Interpreter interpreter;
        private String script;
        private InterpreterContext context;
        private Map<String, Object> infos;
        private Object results;

        public InterpretJob(String jobId, String jobName, JobListener listener, long progressUpdateIntervalMsec, Interpreter interpreter, String script, InterpreterContext context) {
            super(jobId, jobName, listener, progressUpdateIntervalMsec);
            this.interpreter = interpreter;
            this.script = script;
            this.context = context;
        }

        @Override
        public Object getReturn() {
            return this.results;
        }

        @Override
        public int progress() {
            return 0;
        }

        @Override
        public Map<String, Object> info() {
            if (this.infos == null) {
                this.infos = new HashMap<String, Object>();
            }
            return this.infos;
        }

        private void processInterpreterHooks(final String noteId) {
            InterpreterHookListener hookListener = new InterpreterHookListener(){

                @Override
                public void onPreExecute(String script) {
                    String cmdDev = InterpretJob.this.interpreter.getHook(noteId, InterpreterHookRegistry.HookType.PRE_EXEC_DEV.getName());
                    String cmdUser = InterpretJob.this.interpreter.getHook(noteId, InterpreterHookRegistry.HookType.PRE_EXEC.getName());
                    List<String> cmds = Arrays.asList(cmdDev, cmdUser);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = cmd + '\n' + script;
                    }
                    InterpretJob.this.script = script;
                }

                @Override
                public void onPostExecute(String script) {
                    String cmdDev = InterpretJob.this.interpreter.getHook(noteId, InterpreterHookRegistry.HookType.POST_EXEC_DEV.getName());
                    String cmdUser = InterpretJob.this.interpreter.getHook(noteId, InterpreterHookRegistry.HookType.POST_EXEC.getName());
                    List<String> cmds = Arrays.asList(cmdUser, cmdDev);
                    for (String cmd : cmds) {
                        if (cmd == null) continue;
                        script = script + '\n' + cmd;
                    }
                    InterpretJob.this.script = script;
                }
            };
            hookListener.onPreExecute(this.script);
            hookListener.onPostExecute(this.script);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object jobRun() throws Throwable {
            ClassLoader currentThreadContextClassloader = Thread.currentThread().getContextClassLoader();
            try {
                int lastMessageIndex;
                InterpreterContext.set(this.context);
                InterpreterResult result = null;
                LazyOpenInterpreter lazy = (LazyOpenInterpreter)this.interpreter;
                if (!lazy.isOpen()) {
                    lazy.open();
                    result = lazy.executePrecode(this.context);
                }
                if (result == null || result.code() == InterpreterResult.Code.SUCCESS) {
                    this.processInterpreterHooks(this.context.getNoteId());
                    this.processInterpreterHooks(null);
                    logger.debug("Script after hooks: " + this.script);
                    result = this.interpreter.interpret(this.script, this.context);
                }
                this.context.out.flush();
                List<InterpreterResultMessage> resultMessages = this.context.out.toInterpreterResultMessage();
                resultMessages.addAll(result.message());
                for (InterpreterResultMessage msg : resultMessages) {
                    if (msg.getType() == InterpreterResult.Type.IMG) {
                        logger.debug("InterpreterResultMessage: IMAGE_DATA");
                        continue;
                    }
                    logger.debug("InterpreterResultMessage: " + msg.toString());
                }
                if (resultMessages.size() > 0 && resultMessages.get(lastMessageIndex = resultMessages.size() - 1).getType() == InterpreterResult.Type.TABLE) {
                    this.context.getResourcePool().put(this.context.getNoteId(), this.context.getParagraphId(), WellKnownResourceName.ZeppelinTableResult.toString(), resultMessages.get(lastMessageIndex));
                }
                InterpreterResult interpreterResult = new InterpreterResult(result.code(), resultMessages);
                return interpreterResult;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentThreadContextClassloader);
                InterpreterContext.remove();
            }
        }

        @Override
        protected boolean jobAbort() {
            return false;
        }

        @Override
        public void setResult(Object results) {
            this.results = results;
        }
    }

    class InterpretJobListener
    implements JobListener {
        InterpretJobListener() {
        }

        @Override
        public void onProgressUpdate(Job job, int progress) {
        }

        @Override
        public void beforeStatusChange(Job job, Job.Status before, Job.Status after) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void afterStatusChange(Job job, Job.Status before, Job.Status after) {
            InterpretJobListener interpretJobListener = this;
            synchronized (interpretJobListener) {
                this.notifyAll();
            }
        }
    }
}

