/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.zeppelin.scheduler.ExecutorFactory;
import org.apache.zeppelin.scheduler.FIFOScheduler;
import org.apache.zeppelin.scheduler.Job;
import org.apache.zeppelin.scheduler.ParallelScheduler;
import org.apache.zeppelin.scheduler.Scheduler;
import org.apache.zeppelin.scheduler.SchedulerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerFactory
implements SchedulerListener {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerFactory.class);
    protected ExecutorService executor;
    protected Map<String, Scheduler> schedulers = new LinkedHashMap<String, Scheduler>();
    private static SchedulerFactory singleton;
    private static Long singletonLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchedulerFactory singleton() {
        if (singleton == null) {
            Long l = singletonLock;
            synchronized (l) {
                if (singleton == null) {
                    try {
                        singleton = new SchedulerFactory();
                    }
                    catch (Exception e) {
                        logger.error(e.toString(), (Throwable)e);
                    }
                }
            }
        }
        return singleton;
    }

    SchedulerFactory() throws Exception {
        this.executor = ExecutorFactory.singleton().createOrGet("SchedulerFactory", 100);
    }

    public void destroy() {
        ExecutorFactory.singleton().shutdown("SchedulerFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetFIFOScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(name)) {
                FIFOScheduler s = new FIFOScheduler(name, this.executor, this);
                this.schedulers.put(name, s);
                this.executor.execute(s);
            }
            return this.schedulers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetParallelScheduler(String name, int maxConcurrency) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(name)) {
                ParallelScheduler s = new ParallelScheduler(name, this.executor, this, maxConcurrency);
                this.schedulers.put(name, s);
                this.executor.execute(s);
            }
            return this.schedulers.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Scheduler createOrGetScheduler(Scheduler scheduler) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            if (!this.schedulers.containsKey(scheduler.getName())) {
                this.schedulers.put(scheduler.getName(), scheduler);
                this.executor.execute(scheduler);
            }
            return this.schedulers.get(scheduler.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScheduler(String name) {
        Map<String, Scheduler> map = this.schedulers;
        synchronized (map) {
            Scheduler s = this.schedulers.remove(name);
            if (s != null) {
                s.stop();
            }
        }
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void jobStarted(Scheduler scheduler, Job job) {
        logger.info("Job " + job.getId() + " started by scheduler " + scheduler.getName());
    }

    @Override
    public void jobFinished(Scheduler scheduler, Job job) {
        logger.info("Job " + job.getId() + " finished by scheduler " + scheduler.getName());
    }

    static {
        singletonLock = new Long(0L);
    }
}

