/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import org.apache.zeppelin.interpreter.InterpreterPropertyType;

public class DefaultInterpreterProperty {
    private String envName;
    private String propertyName;
    private Object defaultValue;
    private String description;
    private String type;

    public DefaultInterpreterProperty(String envName, String propertyName, Object defaultValue, String description, String type) {
        this.envName = envName;
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.description = description;
        this.type = type;
    }

    public DefaultInterpreterProperty(Object defaultValue, String description, String type) {
        this(null, null, defaultValue, description, type);
    }

    public DefaultInterpreterProperty(Object defaultValue, String description) {
        this(null, null, defaultValue, description, InterpreterPropertyType.TEXTAREA.getValue());
    }

    public DefaultInterpreterProperty(String envName, String propertyName, String defaultValue) {
        this(envName, propertyName, defaultValue, null, InterpreterPropertyType.TEXTAREA.getValue());
    }

    public DefaultInterpreterProperty(String envName, String propertyName, String defaultValue, String description) {
        this(envName, propertyName, defaultValue, description, InterpreterPropertyType.TEXTAREA.getValue());
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public Object getValue() {
        String propValue;
        String envValue;
        if (this.envName != null && !this.envName.isEmpty() && (envValue = System.getenv().get(this.envName)) != null) {
            return envValue;
        }
        if (this.propertyName != null && !this.propertyName.isEmpty() && (propValue = System.getProperty(this.propertyName)) != null) {
            return propValue;
        }
        return this.defaultValue;
    }

    public String toString() {
        return String.format("{envName=%s, propertyName=%s, defaultValue=%s, description=%20s, type=%s}", this.envName, this.propertyName, this.defaultValue, this.description, this.type);
    }
}

