/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.interpreter.InterpreterOutputChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterOutputChangeWatcher
extends Thread {
    Logger logger = LoggerFactory.getLogger(InterpreterOutputChangeWatcher.class);
    private WatchService watcher;
    private final List<File> watchFiles = new LinkedList<File>();
    private final Map<WatchKey, File> watchKeys = new HashMap<WatchKey, File>();
    private InterpreterOutputChangeListener listener;
    private boolean stop;

    public InterpreterOutputChangeWatcher(InterpreterOutputChangeListener listener) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file.getName() + " is not a file");
        }
        String dirString = file.getParentFile().getAbsolutePath();
        if (dirString == null) {
            dirString = "/";
        }
        Path dir = FileSystems.getDefault().getPath(dirString, new String[0]);
        this.logger.info("watch " + dir);
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        Map<WatchKey, File> map = this.watchKeys;
        synchronized (map) {
            this.watchKeys.put(key, new File(dirString));
            this.watchFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<WatchKey, File> map = this.watchKeys;
        synchronized (map) {
            for (WatchKey key : this.watchKeys.keySet()) {
                key.cancel();
            }
            this.watchKeys.clear();
            this.watchFiles.clear();
        }
    }

    public void shutdown() throws IOException {
        this.stop = true;
        this.clear();
        this.watcher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            WatchKey key = null;
            try {
                key = this.watcher.poll(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                break;
            }
            if (key == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                Map<WatchKey, File> map = this.watchKeys;
                synchronized (map) {
                    for (File f : this.watchFiles) {
                        if (f.getName().compareTo(filename.toString()) != 0) continue;
                        File changedFile = filename.isAbsolute() ? new File(filename.toString()) : new File(this.watchKeys.get(key), filename.toString());
                        this.logger.info("File change detected " + changedFile.getAbsolutePath());
                        if (this.listener == null) continue;
                        this.listener.fileChanged(changedFile);
                    }
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            break;
        }
    }
}

