/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.Constants;
import org.apache.zeppelin.interpreter.Interpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KerberosInterpreter
extends Interpreter {
    private Integer kinitFailCount = 0;
    private ScheduledExecutorService scheduledExecutorService;
    private static Logger logger = LoggerFactory.getLogger(KerberosInterpreter.class);

    public KerberosInterpreter(Properties property) {
        super(property);
    }

    @ZeppelinApi
    protected abstract boolean runKerberosLogin();

    @ZeppelinApi
    protected abstract boolean isKerboseEnabled();

    @Override
    public void open() {
        if (this.isKerboseEnabled()) {
            this.startKerberosLoginThread();
        }
    }

    @Override
    public void close() {
        if (this.isKerboseEnabled()) {
            this.shutdownExecutorService();
        }
    }

    private Long getKerberosRefreshInterval() {
        Long refreshInterval;
        String refreshIntervalString = "1d";
        if (System.getenv("KERBEROS_REFRESH_INTERVAL") != null) {
            refreshIntervalString = System.getenv("KERBEROS_REFRESH_INTERVAL");
        }
        try {
            refreshInterval = this.getTimeAsMs(refreshIntervalString);
        }
        catch (IllegalArgumentException e) {
            logger.error("Cannot get time in MS for the given string, " + refreshIntervalString + " defaulting to 1d ", (Throwable)e);
            refreshInterval = this.getTimeAsMs("1d");
        }
        return refreshInterval;
    }

    private Integer kinitFailThreshold() {
        Integer kinitFailThreshold = 5;
        if (System.getenv("KINIT_FAIL_THRESHOLD") != null) {
            try {
                kinitFailThreshold = new Integer(System.getenv("KINIT_FAIL_THRESHOLD"));
            }
            catch (Exception e) {
                logger.error("Cannot get integer value from the given string, " + System.getenv("KINIT_FAIL_THRESHOLD") + " defaulting to " + kinitFailThreshold, (Throwable)e);
            }
        }
        return kinitFailThreshold;
    }

    private Long getTimeAsMs(String time) {
        Matcher m;
        if (time == null) {
            logger.error("Cannot convert to time value.", (Object)time);
            time = "1d";
        }
        if (!(m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(time.toLowerCase())).matches()) {
            throw new IllegalArgumentException("Invalid time string: " + time);
        }
        long val = Long.parseLong(m.group(1));
        String suffix = m.group(2);
        if (suffix != null && !Constants.TIME_SUFFIXES.containsKey(suffix)) {
            throw new IllegalArgumentException("Invalid suffix: \"" + suffix + "\"");
        }
        return TimeUnit.MILLISECONDS.convert(val, suffix != null ? Constants.TIME_SUFFIXES.get(suffix) : TimeUnit.MILLISECONDS);
    }

    private ScheduledExecutorService startKerberosLoginThread() {
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.scheduledExecutorService.submit(new Callable(){

            public Object call() throws Exception {
                if (KerberosInterpreter.this.runKerberosLogin()) {
                    logger.info("Ran runKerberosLogin command successfully.");
                    KerberosInterpreter.this.kinitFailCount = 0;
                    KerberosInterpreter.this.scheduledExecutorService.schedule(this, (long)KerberosInterpreter.this.getKerberosRefreshInterval(), TimeUnit.MILLISECONDS);
                } else {
                    Integer n = KerberosInterpreter.this.kinitFailCount;
                    Integer n2 = KerberosInterpreter.this.kinitFailCount = KerberosInterpreter.this.kinitFailCount + 1;
                    logger.info("runKerberosLogin failed for " + KerberosInterpreter.this.kinitFailCount + " time(s).");
                    if (KerberosInterpreter.this.kinitFailCount >= KerberosInterpreter.this.kinitFailThreshold()) {
                        logger.error("runKerberosLogin failed for  max attempts, calling close interpreter.");
                        KerberosInterpreter.this.close();
                    } else {
                        KerberosInterpreter.this.scheduledExecutorService.submit(this);
                    }
                }
                return null;
            }
        });
        return this.scheduledExecutorService;
    }

    private void shutdownExecutorService() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
    }
}

