/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.resource.ByteBufferInputStream;
import org.apache.zeppelin.resource.LocalResourcePool;
import org.apache.zeppelin.resource.ResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
implements JsonSerializable {
    private static final Gson gson = new Gson();
    private final transient Object r;
    private final transient LocalResourcePool pool;
    private final boolean serializable;
    private final ResourceId resourceId;
    private final String className;

    Resource(LocalResourcePool pool, ResourceId resourceId, Object r) {
        this.r = r;
        this.pool = pool;
        this.resourceId = resourceId;
        this.serializable = r instanceof Serializable;
        this.className = r.getClass().getName();
    }

    Resource(LocalResourcePool pool, ResourceId resourceId, boolean serializable, String className) {
        this.r = null;
        this.pool = pool;
        this.resourceId = resourceId;
        this.serializable = serializable;
        this.className = className;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public String getClassName() {
        return this.className;
    }

    public Object get() {
        if (this.isLocal() || this.isSerializable()) {
            return this.r;
        }
        return null;
    }

    public boolean isSerializable() {
        return this.serializable;
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public boolean isLocal() {
        return true;
    }

    public Object invokeMethod(String methodName, Class[] paramTypes, Object[] params) {
        if (this.r != null) {
            try {
                Method method = this.r.getClass().getMethod(methodName, paramTypes);
                method.setAccessible(true);
                Object ret = method.invoke(this.r, params);
                return ret;
            }
            catch (Exception e) {
                this.logException(e);
                return null;
            }
        }
        return null;
    }

    public Resource invokeMethod(String methodName, Class[] paramTypes, Object[] params, String returnResourceName) {
        if (this.r != null) {
            try {
                Method method = this.r.getClass().getMethod(methodName, paramTypes);
                Object ret = method.invoke(this.r, params);
                this.pool.put(this.resourceId.getNoteId(), this.resourceId.getParagraphId(), returnResourceName, ret);
                return this.pool.get(this.resourceId.getNoteId(), this.resourceId.getParagraphId(), returnResourceName);
            }
            catch (Exception e) {
                this.logException(e);
                return null;
            }
        }
        return null;
    }

    public static ByteBuffer serializeObject(Object o) throws IOException {
        if (o == null || !(o instanceof Serializable)) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(o);
            oos.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static Object deserializeObject(ByteBuffer buf) throws IOException, ClassNotFoundException {
        if (buf == null) {
            return null;
        }
        InputStream ins = ByteBufferInputStream.get(buf);
        Object object = null;
        ObjectInputStream oin = new ObjectInputStream(ins);
        object = oin.readObject();
        oin.close();
        ins.close();
        return object;
    }

    private void logException(Exception e) {
        Logger logger = LoggerFactory.getLogger(Resource.class);
        logger.error(e.getMessage(), (Throwable)e);
    }

    @Override
    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static Resource fromJson(String json) {
        return (Resource)gson.fromJson(json, Resource.class);
    }
}

