/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.scheduler.JobListener;
import org.apache.zeppelin.scheduler.JobProgressPoller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Job {
    private String jobName;
    String id;
    Date dateCreated;
    Date dateStarted;
    Date dateFinished;
    volatile Status status;
    static Logger LOGGER = LoggerFactory.getLogger(Job.class);
    transient boolean aborted = false;
    private volatile String errorMessage;
    private volatile transient Throwable exception;
    private transient JobListener listener;
    private long progressUpdateIntervalMs;

    public Job(String jobName, JobListener listener, long progressUpdateIntervalMs) {
        this.jobName = jobName;
        this.listener = listener;
        this.progressUpdateIntervalMs = progressUpdateIntervalMs;
        this.dateCreated = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        this.id = dateFormat.format(this.dateCreated) + "_" + super.hashCode();
        this.setStatus(Status.READY);
    }

    public Job(String jobName, JobListener listener) {
        this(jobName, listener, 500L);
    }

    public Job(String jobId, String jobName, JobListener listener) {
        this(jobId, jobName, listener, 500L);
    }

    public Job(String jobId, String jobName, JobListener listener, long progressUpdateIntervalMs) {
        this.jobName = jobName;
        this.listener = listener;
        this.progressUpdateIntervalMs = progressUpdateIntervalMs;
        this.dateCreated = new Date();
        this.id = jobId;
        this.setStatus(Status.READY);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return ((Job)o).hashCode() == this.hashCode();
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatusWithoutNotification(Status status) {
        this.status = status;
    }

    public void setStatus(Status status) {
        if (this.status == status) {
            return;
        }
        Status before = this.status;
        Status after = status;
        if (this.listener != null) {
            this.listener.beforeStatusChange(this, before, after);
        }
        this.status = status;
        if (this.listener != null) {
            this.listener.afterStatusChange(this, before, after);
        }
    }

    public void setListener(JobListener listener) {
        this.listener = listener;
    }

    public JobListener getListener() {
        return this.listener;
    }

    public boolean isTerminated() {
        return !this.status.isReady() && !this.status.isRunning() && !this.status.isPending();
    }

    public boolean isRunning() {
        return this.status.isRunning();
    }

    public void run() {
        Thread progressUpdator = null;
        this.dateStarted = new Date();
        try {
            progressUpdator = new JobProgressPoller(this, this.progressUpdateIntervalMs);
            progressUpdator.start();
            this.completeWithSuccess(this.jobRun());
        }
        catch (Throwable e) {
            LOGGER.error("Job failed", e);
            this.completeWithError(e);
        }
        finally {
            if (progressUpdator != null) {
                progressUpdator.interrupt();
            }
        }
    }

    private synchronized void completeWithSuccess(Object result) {
        this.setResult(result);
        this.exception = null;
        this.errorMessage = null;
        this.dateFinished = new Date();
    }

    private synchronized void completeWithError(Throwable error) {
        this.setResult(new InterpreterResult(InterpreterResult.Code.ERROR, Job.getStack(error)));
        this.setException(error);
        this.dateFinished = new Date();
    }

    public static String getStack(Throwable e) {
        if (e == null) {
            return "";
        }
        Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
        if (cause != null) {
            return ExceptionUtils.getFullStackTrace((Throwable)cause);
        }
        return ExceptionUtils.getFullStackTrace((Throwable)e);
    }

    public synchronized Throwable getException() {
        return this.exception;
    }

    protected synchronized void setException(Throwable t) {
        this.exception = t;
        this.errorMessage = Job.getStack(t);
    }

    public abstract Object getReturn();

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public abstract int progress();

    public abstract Map<String, Object> info();

    protected abstract Object jobRun() throws Throwable;

    protected abstract boolean jobAbort();

    public void abort() {
        this.aborted = this.jobAbort();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public synchronized void setDateStarted(Date startedAt) {
        this.dateStarted = startedAt;
    }

    public synchronized Date getDateFinished() {
        return this.dateFinished;
    }

    public synchronized void setDateFinished(Date finishedAt) {
        this.dateFinished = finishedAt;
    }

    public abstract void setResult(Object var1);

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public static enum Status {
        UNKNOWN,
        READY,
        PENDING,
        RUNNING,
        FINISHED,
        ERROR,
        ABORT;


        public boolean isReady() {
            return this == READY;
        }

        public boolean isRunning() {
            return this == RUNNING;
        }

        public boolean isPending() {
            return this == PENDING;
        }

        public boolean isCompleted() {
            return this == FINISHED || this == ERROR || this == ABORT;
        }
    }
}

