/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectWatcher;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterContextRunner;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.interpreter.RemoteWorksController;
import org.apache.zeppelin.interpreter.remote.RemoteEventClientWrapper;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseZeppelinContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseZeppelinContext.class);
    protected InterpreterContext interpreterContext;
    protected int maxResult;
    protected InterpreterHookRegistry hooks;
    protected GUI gui;
    protected GUI noteGui;
    private static RemoteEventClientWrapper eventClient;

    public BaseZeppelinContext(InterpreterHookRegistry hooks, int maxResult) {
        this.hooks = hooks;
        this.maxResult = maxResult;
    }

    public abstract Map<String, String> getInterpreterClassMap();

    public abstract List<Class> getSupportedClasses();

    public int getMaxResult() {
        return this.maxResult;
    }

    protected abstract String showData(Object var1);

    @Deprecated
    @ZeppelinApi
    public Object input(String name) {
        return this.textbox(name);
    }

    @Deprecated
    @ZeppelinApi
    public Object input(String name, Object defaultValue) {
        return this.textbox(name, defaultValue.toString(), false);
    }

    @ZeppelinApi
    public Object textbox(String name) {
        return this.textbox(name, "", false);
    }

    @ZeppelinApi
    public Object textbox(String name, String defaultValue) {
        return this.textbox(name, defaultValue, false);
    }

    @ZeppelinApi
    public Collection<Object> checkbox(String name, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, false);
    }

    @ZeppelinApi
    public Collection<Object> checkbox(String name, List<Object> defaultChecked, OptionInput.ParamOption[] options) {
        return this.checkbox(name, defaultChecked, options, false);
    }

    @ZeppelinApi
    public Object select(String name, Object defaultValue, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, defaultValue, paramOptions, false);
    }

    @ZeppelinApi
    public Object noteTextbox(String name) {
        return this.textbox(name, "");
    }

    @ZeppelinApi
    public Object noteTextbox(String name, String defaultValue) {
        return this.textbox(name, defaultValue, true);
    }

    @ZeppelinApi
    public Collection<Object> noteCheckbox(String name, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, true);
    }

    @ZeppelinApi
    public Collection<Object> noteCheckbox(String name, List<Object> defaultChecked, OptionInput.ParamOption[] options) {
        return this.checkbox(name, defaultChecked, options, true);
    }

    @ZeppelinApi
    public Object noteSelect(String name, Object defaultValue, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, defaultValue, paramOptions, true);
    }

    private Object select(String name, Object defaultValue, OptionInput.ParamOption[] paramOptions, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.select(name, defaultValue, paramOptions);
        }
        return this.gui.select(name, defaultValue, paramOptions);
    }

    private Object textbox(String name, String defaultValue, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.textbox(name, defaultValue);
        }
        return this.gui.textbox(name, defaultValue);
    }

    private Collection<Object> checkbox(String name, OptionInput.ParamOption[] options, boolean noteForm) {
        LinkedList<Object> defaultValues = new LinkedList<Object>();
        for (OptionInput.ParamOption option : options) {
            defaultValues.add(option.getValue());
        }
        if (noteForm) {
            return this.noteGui.checkbox(name, defaultValues, options);
        }
        return this.gui.checkbox(name, defaultValues, options);
    }

    private Collection<Object> checkbox(String name, List<Object> defaultChecked, OptionInput.ParamOption[] options, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.checkbox(name, defaultChecked, options);
        }
        return this.gui.checkbox(name, defaultChecked, options);
    }

    public void setGui(GUI o) {
        this.gui = o;
    }

    public GUI getGui() {
        return this.gui;
    }

    public GUI getNoteGui() {
        return this.noteGui;
    }

    public void setNoteGui(GUI noteGui) {
        this.noteGui = noteGui;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public void setInterpreterContext(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    @ZeppelinApi
    public void show(Object o) {
        this.show(o, this.maxResult);
    }

    @ZeppelinApi
    public void show(Object o, int maxResult) {
        try {
            if (this.isSupportedObject(o)) {
                this.interpreterContext.out.write(this.showData(o));
            } else {
                this.interpreterContext.out.write("ZeppelinContext doesn't support to show type: " + o.getClass().getCanonicalName() + "\n");
                this.interpreterContext.out.write(o.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSupportedObject(Object obj) {
        for (Class supportedClass : this.getSupportedClasses()) {
            if (!supportedClass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId) {
        this.run(noteId, paragraphId, this.interpreterContext, true);
    }

    @ZeppelinApi
    public void run(String paragraphId) {
        this.run(paragraphId, true);
    }

    @ZeppelinApi
    public void run(String paragraphId, boolean checkCurrentParagraph) {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, paragraphId, this.interpreterContext, checkCurrentParagraph);
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId, InterpreterContext context) {
        this.run(noteId, paragraphId, context, true);
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId, InterpreterContext context, boolean checkCurrentParagraph) {
        if (paragraphId.equals(context.getParagraphId()) && checkCurrentParagraph) {
            throw new RuntimeException("Can not run current Paragraph");
        }
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, paragraphId, context);
        if (runners.size() <= 0) {
            throw new RuntimeException("Paragraph " + paragraphId + " not found " + runners.size());
        }
        for (InterpreterContextRunner r : runners) {
            r.run();
        }
    }

    public void runNote(String noteId) {
        this.runNote(noteId, this.interpreterContext);
    }

    public void runNote(String noteId, InterpreterContext context) {
        String runningNoteId = context.getNoteId();
        String runningParagraphId = context.getParagraphId();
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, context);
        if (runners.size() <= 0) {
            throw new RuntimeException("Note " + noteId + " not found " + runners.size());
        }
        for (InterpreterContextRunner r : runners) {
            if (r.getNoteId().equals(runningNoteId) && r.getParagraphId().equals(runningParagraphId)) continue;
            LOGGER.debug("Run Paragraph: " + r.getParagraphId() + " of Note: " + r.getNoteId());
            r.run();
        }
    }

    @ZeppelinApi
    public List<InterpreterContextRunner> getInterpreterContextRunner(String noteId, InterpreterContext interpreterContext) {
        List<InterpreterContextRunner> runners = new LinkedList<InterpreterContextRunner>();
        RemoteWorksController remoteWorksController = interpreterContext.getRemoteWorksController();
        if (remoteWorksController != null) {
            runners = remoteWorksController.getRemoteContextRunner(noteId);
        }
        return runners;
    }

    @ZeppelinApi
    public List<InterpreterContextRunner> getInterpreterContextRunner(String noteId, String paragraphId, InterpreterContext interpreterContext) {
        List<InterpreterContextRunner> runners = new LinkedList<InterpreterContextRunner>();
        RemoteWorksController remoteWorksController = interpreterContext.getRemoteWorksController();
        if (remoteWorksController != null) {
            runners = remoteWorksController.getRemoteContextRunner(noteId, paragraphId);
        }
        return runners;
    }

    @ZeppelinApi
    public void run(int idx) {
        this.run(idx, true);
    }

    public void run(int idx, boolean checkCurrentParagraph) {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, idx, this.interpreterContext, checkCurrentParagraph);
    }

    public void run(String noteId, int idx, InterpreterContext context) {
        this.run(noteId, idx, context, true);
    }

    public void run(String noteId, int idx, InterpreterContext context, boolean checkCurrentParagraph) {
        List<InterpreterContextRunner> runners = this.getInterpreterContextRunner(noteId, context);
        if (idx >= runners.size()) {
            throw new RuntimeException("Index out of bound");
        }
        InterpreterContextRunner runner = runners.get(idx);
        if (runner.getParagraphId().equals(context.getParagraphId()) && checkCurrentParagraph) {
            throw new RuntimeException("Can not run current Paragraph: " + runner.getParagraphId());
        }
        runner.run();
    }

    @ZeppelinApi
    public void run(List<Object> paragraphIdOrIdx) {
        this.run(paragraphIdOrIdx, this.interpreterContext);
    }

    @ZeppelinApi
    public void run(List<Object> paragraphIdOrIdx, InterpreterContext context) {
        String noteId = context.getNoteId();
        for (Object idOrIdx : paragraphIdOrIdx) {
            if (idOrIdx instanceof String) {
                String paragraphId = (String)idOrIdx;
                this.run(noteId, paragraphId, context);
                continue;
            }
            if (idOrIdx instanceof Integer) {
                Integer idx = (Integer)idOrIdx;
                this.run(noteId, idx, context);
                continue;
            }
            throw new RuntimeException("Paragraph " + idOrIdx + " not found");
        }
    }

    @ZeppelinApi
    public void runAll() {
        this.runAll(this.interpreterContext);
    }

    @ZeppelinApi
    public void runAll(InterpreterContext context) {
        this.runNote(context.getNoteId());
    }

    @ZeppelinApi
    public List<String> listParagraphs() {
        LinkedList<String> paragraphs = new LinkedList<String>();
        for (InterpreterContextRunner r : this.interpreterContext.getRunners()) {
            paragraphs.add(r.getParagraphId());
        }
        return paragraphs;
    }

    private AngularObject getAngularObject(String name, InterpreterContext interpreterContext) {
        AngularObject ao;
        AngularObjectRegistry registry = interpreterContext.getAngularObjectRegistry();
        String noteId = interpreterContext.getNoteId();
        AngularObject paragraphAo = registry.get(name, noteId, interpreterContext.getParagraphId());
        AngularObject noteAo = registry.get(name, noteId, null);
        AngularObject angularObject = ao = paragraphAo != null ? paragraphAo : noteAo;
        if (ao == null) {
            ao = registry.get(name, null, null);
        }
        return ao;
    }

    @ZeppelinApi
    public Object angular(String name) {
        AngularObject ao = this.getAngularObject(name, this.interpreterContext);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @Deprecated
    public Object angularGlobal(String name) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, null, null);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @ZeppelinApi
    public void angularBind(String name, Object o) {
        this.angularBind(name, o, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o) {
        this.angularBind(name, o, (String)null);
    }

    @ZeppelinApi
    public void angularBind(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, null, watcher);
    }

    @ZeppelinApi
    public void angularWatch(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularWatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularUnwatch(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularUnwatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularUnwatch(String name) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularUnwatchGlobal(String name) {
        this.angularUnwatch(name, (String)null);
    }

    @ZeppelinApi
    public void angularUnbind(String name) {
        String noteId = this.interpreterContext.getNoteId();
        this.angularUnbind(name, noteId);
    }

    @Deprecated
    public void angularUnbindGlobal(String name) {
        this.angularUnbind(name, null);
    }

    private void angularBind(String name, Object o, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
    }

    private void angularBind(String name, Object o, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
        this.angularWatch(name, watcher);
    }

    public void angularWatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).addWatcher(watcher);
        }
    }

    private void angularUnwatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).removeWatcher(watcher);
        }
    }

    private void angularUnwatch(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).clearAllWatchers();
        }
    }

    private void angularUnbind(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        registry.remove(name, noteId, null);
    }

    private String getClassNameFromReplName(String replName) {
        String[] splits = replName.split(".");
        if (splits.length > 1) {
            replName = splits[splits.length - 1];
        }
        return this.getInterpreterClassMap().get(replName);
    }

    @Experimental
    public void registerHook(String event, String cmd, String replName) throws InvalidHookException {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.register(null, className, event, cmd);
    }

    @Experimental
    public void registerHook(String event, String cmd) throws InvalidHookException {
        String replClassName = this.interpreterContext.getClassName();
        this.hooks.register(null, replClassName, event, cmd);
    }

    @Experimental
    public void registerNoteHook(String event, String cmd, String noteId) throws InvalidHookException {
        String replClassName = this.interpreterContext.getClassName();
        this.hooks.register(noteId, replClassName, event, cmd);
    }

    @Experimental
    public void registerNoteHook(String event, String cmd, String noteId, String replName) throws InvalidHookException {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.register(noteId, className, event, cmd);
    }

    @Experimental
    public void unregisterHook(String event, String replName) {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.unregister(null, className, event);
    }

    @Experimental
    public void unregisterHook(String event) {
        this.unregisterHook(event, this.interpreterContext.getReplName());
    }

    @Experimental
    public void unregisterNoteHook(String noteId, String event) {
        String className = this.interpreterContext.getClassName();
        this.hooks.unregister(noteId, className, event);
    }

    @Experimental
    public void unregisterNoteHook(String noteId, String event, String replName) {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.unregister(noteId, className, event);
    }

    @ZeppelinApi
    public void put(String name, Object value) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.put(name, value);
    }

    @ZeppelinApi
    public Object get(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        if (resource != null) {
            return resource.get();
        }
        return null;
    }

    @ZeppelinApi
    public void remove(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.remove(name);
    }

    @ZeppelinApi
    public boolean containsKey(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        return resource != null;
    }

    @ZeppelinApi
    public ResourceSet getAll() {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        return resourcePool.getAll();
    }

    @ZeppelinApi
    public static RemoteEventClientWrapper getEventClient() {
        return eventClient;
    }

    @ZeppelinApi
    public void setEventClient(RemoteEventClientWrapper eventClient) {
        BaseZeppelinContext.eventClient = eventClient;
    }
}

