/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cluster.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.cluster.event.ClusterEvent;
import org.apache.zeppelin.display.Input;

public class ClusterMessage {
    public ClusterEvent clusterEvent;
    private Map<String, String> data = new HashMap<String, String>();
    private String msgId;
    private static Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)Input.TypeAdapterFactory).create();

    public ClusterMessage(ClusterEvent event) {
        this.clusterEvent = event;
    }

    public ClusterMessage put(String k, String v) {
        this.data.put(k, v);
        return this;
    }

    public ClusterMessage put(Map<String, String> params) {
        this.data.putAll(params);
        return this;
    }

    public String get(String k) {
        return this.data.get(k);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public static ClusterMessage deserializeMessage(String msg) {
        return (ClusterMessage)gson.fromJson(msg, ClusterMessage.class);
    }

    public static String serializeMessage(ClusterMessage m) {
        return gson.toJson((Object)m);
    }
}

