/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;

public abstract class AbstractInterpreter
extends Interpreter {
    public AbstractInterpreter(Properties properties) {
        super(properties);
    }

    @Override
    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        boolean interpolate;
        InterpreterContext.set(context);
        ZeppelinContext z = this.getZeppelinContext();
        if (z != null) {
            z.setGui(context.getGui());
            z.setNoteGui(context.getNoteGui());
            z.setInterpreterContext(context);
        }
        boolean bl = interpolate = this.isInterpolate() || Boolean.parseBoolean(context.getLocalProperties().getOrDefault("interpolate", "false"));
        if (interpolate) {
            st = this.interpolate(st, context.getResourcePool());
        }
        return this.internalInterpret(st, context);
    }

    public abstract ZeppelinContext getZeppelinContext();

    protected boolean isInterpolate() {
        return false;
    }

    protected abstract InterpreterResult internalInterpret(String var1, InterpreterContext var2) throws InterpreterException;

    @Override
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        return new ArrayList<InterpreterCompletion>();
    }
}

