/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.resource.ResourcePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterGroup.class);
    protected String id;
    private String webUrl;
    protected Map<String, List<Interpreter>> sessions = new ConcurrentHashMap<String, List<Interpreter>>();
    private AngularObjectRegistry angularObjectRegistry;
    private InterpreterHookRegistry hookRegistry;
    private ResourcePool resourcePool;
    private boolean angularRegistryPushed = false;

    public InterpreterGroup(String id) {
        this.id = id;
    }

    public InterpreterGroup() {
        this.id = InterpreterGroup.generateId();
    }

    private static String generateId() {
        return "InterpreterGroup_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt();
    }

    public String getId() {
        return this.id;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public void setWebUrl(String webUrl) {
        this.webUrl = webUrl;
    }

    public synchronized List<Interpreter> get(String sessionId) {
        return this.sessions.get(sessionId);
    }

    public synchronized void put(String sessionId, List<Interpreter> interpreters) {
        this.sessions.put(sessionId, interpreters);
    }

    public synchronized void addInterpreterToSession(Interpreter interpreter, String sessionId) {
        LOGGER.debug("Add Interpreter {} to session {}", (Object)interpreter.getClassName(), (Object)sessionId);
        List<Interpreter> interpreters = this.get(sessionId);
        if (interpreters == null) {
            interpreters = new ArrayList<Interpreter>();
        }
        interpreters.add(interpreter);
        this.put(sessionId, interpreters);
    }

    public Collection<List<Interpreter>> values() {
        return this.sessions.values();
    }

    public AngularObjectRegistry getAngularObjectRegistry() {
        return this.angularObjectRegistry;
    }

    public void setAngularObjectRegistry(AngularObjectRegistry angularObjectRegistry) {
        this.angularObjectRegistry = angularObjectRegistry;
    }

    public InterpreterHookRegistry getInterpreterHookRegistry() {
        return this.hookRegistry;
    }

    public void setInterpreterHookRegistry(InterpreterHookRegistry hookRegistry) {
        this.hookRegistry = hookRegistry;
    }

    public int getSessionNum() {
        return this.sessions.size();
    }

    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    public boolean isAngularRegistryPushed() {
        return this.angularRegistryPushed;
    }

    public void setAngularRegistryPushed(boolean angularRegistryPushed) {
        this.angularRegistryPushed = angularRegistryPushed;
    }

    public boolean isEmpty() {
        return this.sessions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterpreterGroup)) {
            return false;
        }
        InterpreterGroup that = (InterpreterGroup)o;
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public void close() {
        for (List<Interpreter> session : this.sessions.values()) {
            for (Interpreter interpreter : session) {
                try {
                    interpreter.close();
                    interpreter.getScheduler().stop();
                }
                catch (InterpreterException e) {
                    LOGGER.warn("Fail to close interpreter: {}", (Object)interpreter.getClassName(), (Object)e);
                }
            }
        }
        this.sessions.clear();
    }
}

