/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.display.AngularObject;
import org.apache.zeppelin.display.AngularObjectRegistry;
import org.apache.zeppelin.display.AngularObjectWatcher;
import org.apache.zeppelin.display.GUI;
import org.apache.zeppelin.display.ui.OptionInput;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.resource.Resource;
import org.apache.zeppelin.resource.ResourcePool;
import org.apache.zeppelin.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ZeppelinContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinContext.class);
    protected InterpreterContext interpreterContext;
    protected int maxResult;
    protected InterpreterHookRegistry hooks;
    protected GUI gui;
    protected GUI noteGui;

    public ZeppelinContext(InterpreterHookRegistry hooks, int maxResult) {
        this.hooks = hooks;
        this.maxResult = maxResult;
    }

    public abstract Map<String, String> getInterpreterClassMap();

    public abstract List<Class> getSupportedClasses();

    public int getMaxResult() {
        return this.maxResult;
    }

    public String showData(Object obj) {
        return this.showData(obj, this.maxResult);
    }

    public abstract String showData(Object var1, int var2);

    @Deprecated
    @ZeppelinApi
    public Object input(String name) {
        return this.textbox(name);
    }

    @Deprecated
    @ZeppelinApi
    public Object input(String name, Object defaultValue) {
        return this.textbox(name, defaultValue.toString(), false);
    }

    @ZeppelinApi
    public Object textbox(String name) {
        return this.textbox(name, "");
    }

    @ZeppelinApi
    public Object textbox(String name, String defaultValue) {
        return this.textbox(name, defaultValue, false);
    }

    @ZeppelinApi
    public Object noteTextbox(String name) {
        return this.noteTextbox(name, "");
    }

    @ZeppelinApi
    public Object noteTextbox(String name, String defaultValue) {
        return this.textbox(name, defaultValue, true);
    }

    private Object textbox(String name, String defaultValue, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.textbox(name, defaultValue);
        }
        return this.gui.textbox(name, defaultValue);
    }

    @ZeppelinApi
    public Object password(String name) {
        return this.password(name, false);
    }

    @ZeppelinApi
    public Object notePassword(String name) {
        return this.password(name, true);
    }

    private Object password(String name, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.password(name);
        }
        return this.gui.password(name);
    }

    @ZeppelinApi
    public List<Object> checkbox(String name, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, null, false);
    }

    @ZeppelinApi
    public List<Object> checkbox(String name, OptionInput.ParamOption[] options, List defaultChecked) {
        return this.checkbox(name, options, defaultChecked, false);
    }

    @Deprecated
    @ZeppelinApi
    public List<Object> checkbox(String name, List<Object> defaultChecked, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, defaultChecked, false);
    }

    @ZeppelinApi
    public List<Object> noteCheckbox(String name, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, null, true);
    }

    @Deprecated
    @ZeppelinApi
    public List<Object> noteCheckbox(String name, List<Object> defaultChecked, OptionInput.ParamOption[] options) {
        return this.checkbox(name, options, defaultChecked, true);
    }

    @ZeppelinApi
    public List<Object> noteCheckbox(String name, OptionInput.ParamOption[] options, List defaultChecked) {
        return this.checkbox(name, options, defaultChecked, true);
    }

    private List<Object> checkbox(String name, OptionInput.ParamOption[] options, List<Object> defaultChecked, boolean noteForm) {
        if (defaultChecked == null) {
            defaultChecked = new ArrayList<Object>();
            for (OptionInput.ParamOption option : options) {
                defaultChecked.add(option.getValue());
            }
        }
        if (noteForm) {
            return this.noteGui.checkbox(name, options, defaultChecked);
        }
        return this.gui.checkbox(name, options, defaultChecked);
    }

    @ZeppelinApi
    public Object select(String name, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, paramOptions, null, false);
    }

    @Deprecated
    @ZeppelinApi
    public Object select(String name, Object defaultValue, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, paramOptions, defaultValue, false);
    }

    @ZeppelinApi
    public Object select(String name, OptionInput.ParamOption[] paramOptions, Object defaultValue) {
        return this.select(name, paramOptions, defaultValue, false);
    }

    @ZeppelinApi
    public Object noteSelect(String name, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, null, paramOptions, true);
    }

    @Deprecated
    @ZeppelinApi
    public Object noteSelect(String name, Object defaultValue, OptionInput.ParamOption[] paramOptions) {
        return this.select(name, paramOptions, defaultValue, true);
    }

    @ZeppelinApi
    public Object noteSelect(String name, OptionInput.ParamOption[] paramOptions, Object defaultValue) {
        return this.select(name, paramOptions, defaultValue, true);
    }

    private Object select(String name, OptionInput.ParamOption[] paramOptions, Object defaultValue, boolean noteForm) {
        if (noteForm) {
            return this.noteGui.select(name, paramOptions, defaultValue);
        }
        return this.gui.select(name, paramOptions, defaultValue);
    }

    public void setGui(GUI o) {
        this.gui = o;
    }

    public GUI getGui() {
        return this.gui;
    }

    public GUI getNoteGui() {
        return this.noteGui;
    }

    public void setNoteGui(GUI noteGui) {
        this.noteGui = noteGui;
    }

    public InterpreterContext getInterpreterContext() {
        return this.interpreterContext;
    }

    public void setInterpreterContext(InterpreterContext interpreterContext) {
        this.interpreterContext = interpreterContext;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    @ZeppelinApi
    public void show(Object o) {
        this.show(o, this.maxResult);
    }

    @ZeppelinApi
    public void show(Object o, int maxResult) {
        try {
            if (this.isSupportedObject(o)) {
                this.interpreterContext.out.write(this.showData(o));
            } else {
                this.interpreterContext.out.write("ZeppelinContext doesn't support to show type: " + o.getClass().getCanonicalName() + "\n");
                this.interpreterContext.out.write(o.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean isSupportedObject(Object obj) {
        for (Class supportedClass : this.getSupportedClasses()) {
            if (!supportedClass.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    @ZeppelinApi
    public void run(String paragraphId) throws IOException {
        this.run(paragraphId, true);
    }

    @ZeppelinApi
    public void run(String paragraphId, boolean checkCurrentParagraph) throws IOException {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, paragraphId, this.interpreterContext, checkCurrentParagraph);
    }

    @ZeppelinApi
    public void run(String noteId, String paragraphId) throws IOException {
        this.run(noteId, paragraphId, InterpreterContext.get(), true);
    }

    public void run(String noteId, String paragraphId, InterpreterContext context) throws IOException {
        this.run(noteId, paragraphId, context, true);
    }

    private void run(String noteId, String paragraphId, InterpreterContext context, boolean checkCurrentParagraph) throws IOException {
        if (paragraphId.equals(context.getParagraphId()) && checkCurrentParagraph) {
            throw new RuntimeException("Can not run current Paragraph");
        }
        ArrayList<String> paragraphIds = new ArrayList<String>();
        paragraphIds.add(paragraphId);
        ArrayList<Integer> paragraphIndices = new ArrayList<Integer>();
        context.getIntpEventClient().runParagraphs(noteId, paragraphIds, paragraphIndices, context.getParagraphId());
    }

    @ZeppelinApi
    public void runNote(String noteId) throws IOException {
        this.runNote(noteId, this.interpreterContext);
    }

    public void runNote(String noteId, InterpreterContext context) throws IOException {
        ArrayList<String> paragraphIds = new ArrayList<String>();
        ArrayList<Integer> paragraphIndices = new ArrayList<Integer>();
        context.getIntpEventClient().runParagraphs(noteId, paragraphIds, paragraphIndices, context.getParagraphId());
    }

    @ZeppelinApi
    public void run(int idx) throws IOException {
        this.run(idx, true);
    }

    @ZeppelinApi
    public void run(int idx, boolean checkCurrentParagraph) throws IOException {
        String noteId = this.interpreterContext.getNoteId();
        this.run(noteId, idx, this.interpreterContext, checkCurrentParagraph);
    }

    private void run(String noteId, int idx, InterpreterContext context) throws IOException {
        this.run(noteId, idx, context, true);
    }

    private void run(String noteId, int idx, InterpreterContext context, boolean checkCurrentParagraph) throws IOException {
        ArrayList<String> paragraphIds = new ArrayList<String>();
        ArrayList<Integer> paragraphIndices = new ArrayList<Integer>();
        paragraphIndices.add(idx);
        context.getIntpEventClient().runParagraphs(noteId, paragraphIds, paragraphIndices, context.getParagraphId());
    }

    @ZeppelinApi
    public void runAll() throws IOException {
        this.runAll(this.interpreterContext);
    }

    public void runAll(InterpreterContext context) throws IOException {
        this.runNote(context.getNoteId());
    }

    private AngularObject getAngularObject(String name, String noteId, String paragraphId, InterpreterContext interpreterContext) {
        AngularObjectRegistry registry = interpreterContext.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, noteId, paragraphId);
        return ao;
    }

    @ZeppelinApi
    public Object angular(String name) {
        AngularObject ao = this.getAngularObject(name, this.interpreterContext.getNoteId(), this.interpreterContext.getParagraphId(), this.interpreterContext);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    public Object angular(String name, String noteId) {
        AngularObject ao = this.getAngularObject(name, noteId, this.interpreterContext.getParagraphId(), this.interpreterContext);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    public Object angular(String name, String noteId, String paragraphId) {
        AngularObject ao = this.getAngularObject(name, noteId, paragraphId, this.interpreterContext);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @Deprecated
    public Object angularGlobal(String name) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        AngularObject ao = registry.get(name, null, null);
        if (ao == null) {
            return null;
        }
        return ao.get();
    }

    @ZeppelinApi
    public void angularBind(String name, Object o) {
        this.angularBind(name, o, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o) {
        this.angularBind(name, o, (String)null);
    }

    @ZeppelinApi
    public void angularBind(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularBindGlobal(String name, Object o, AngularObjectWatcher watcher) {
        this.angularBind(name, o, null, watcher);
    }

    @ZeppelinApi
    public void angularWatch(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularWatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularWatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularUnwatch(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId(), watcher);
    }

    @Deprecated
    public void angularUnwatchGlobal(String name, AngularObjectWatcher watcher) {
        this.angularUnwatch(name, null, watcher);
    }

    @ZeppelinApi
    public void angularUnwatch(String name) {
        this.angularUnwatch(name, this.interpreterContext.getNoteId());
    }

    @Deprecated
    public void angularUnwatchGlobal(String name) {
        this.angularUnwatch(name, (String)null);
    }

    @ZeppelinApi
    public void angularUnbind(String name) {
        String noteId = this.interpreterContext.getNoteId();
        this.angularUnbind(name, noteId);
    }

    @Deprecated
    public void angularUnbindGlobal(String name) {
        this.angularUnbind(name, null);
    }

    public void angularBind(String name, Object o, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
    }

    public void angularBind(String name, Object o, String noteId, String paragraphId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, paragraphId) == null) {
            registry.add(name, o, noteId, paragraphId);
        } else {
            registry.get(name, noteId, paragraphId).set(o);
        }
    }

    private void angularBind(String name, Object o, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) == null) {
            registry.add(name, o, noteId, null);
        } else {
            registry.get(name, noteId, null).set(o);
        }
        this.angularWatch(name, watcher);
    }

    public void angularWatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).addWatcher(watcher);
        }
    }

    private void angularUnwatch(String name, String noteId, AngularObjectWatcher watcher) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).removeWatcher(watcher);
        }
    }

    private void angularUnwatch(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        if (registry.get(name, noteId, null) != null) {
            registry.get(name, noteId, null).clearAllWatchers();
        }
    }

    private void angularUnbind(String name, String noteId) {
        AngularObjectRegistry registry = this.interpreterContext.getAngularObjectRegistry();
        registry.remove(name, noteId, null);
    }

    private String getClassNameFromReplName(String replName) {
        String[] splits = replName.split(".");
        if (splits.length > 1) {
            replName = splits[splits.length - 1];
        }
        return this.getInterpreterClassMap().get(replName);
    }

    @Experimental
    public void registerHook(String event, String cmd, String replName) throws InvalidHookException {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.register(null, className, event, cmd);
    }

    @Experimental
    public void registerHook(String event, String cmd) throws InvalidHookException {
        String replClassName = this.interpreterContext.getInterpreterClassName();
        this.hooks.register(null, replClassName, event, cmd);
    }

    @Experimental
    public void registerNoteHook(String event, String cmd, String noteId) throws InvalidHookException {
        String replClassName = this.interpreterContext.getInterpreterClassName();
        this.hooks.register(noteId, replClassName, event, cmd);
    }

    @Experimental
    public void registerNoteHook(String event, String cmd, String noteId, String replName) throws InvalidHookException {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.register(noteId, className, event, cmd);
    }

    @Experimental
    public void unregisterHook(String event, String replName) {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.unregister(null, className, event);
    }

    @Experimental
    public void unregisterHook(String event) {
        this.unregisterHook(event, this.interpreterContext.getReplName());
    }

    @Experimental
    public void unregisterNoteHook(String noteId, String event) {
        String className = this.interpreterContext.getInterpreterClassName();
        this.hooks.unregister(noteId, className, event);
    }

    @Experimental
    public void unregisterNoteHook(String noteId, String event, String replName) {
        String className = this.getClassNameFromReplName(replName);
        this.hooks.unregister(noteId, className, event);
    }

    @ZeppelinApi
    public void put(String name, Object value) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.put(name, value);
    }

    @ZeppelinApi
    public Object get(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        if (resource != null) {
            return resource.get();
        }
        return null;
    }

    @ZeppelinApi
    public <T> T get(String name, Class<T> clazz) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        if (resource != null) {
            return resource.get(clazz);
        }
        return null;
    }

    @ZeppelinApi
    public void remove(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        resourcePool.remove(name);
    }

    @ZeppelinApi
    public boolean containsKey(String name) {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        Resource resource = resourcePool.get(name);
        return resource != null;
    }

    @ZeppelinApi
    public ResourceSet getAll() {
        ResourcePool resourcePool = this.interpreterContext.getResourcePool();
        return resourcePool.getAll();
    }
}

