/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.scheduler;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.scheduler.SchedulerThreadFactory;
import org.apache.zeppelin.util.ExecutorUtil;

public class ExecutorFactory {
    private Map<String, ExecutorService> executors = new HashMap<String, ExecutorService>();
    private Map<String, ScheduledExecutorService> scheduledExecutors = new HashMap<String, ScheduledExecutorService>();

    private ExecutorFactory() {
    }

    public static ExecutorFactory singleton() {
        return InstanceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService createOrGet(String name, int numThread) {
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            if (!this.executors.containsKey(name)) {
                this.executors.put(name, Executors.newScheduledThreadPool(numThread, new SchedulerThreadFactory(name)));
            }
            return this.executors.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService createOrGetScheduled(String name, int numThread) {
        Map<String, ScheduledExecutorService> map = this.scheduledExecutors;
        synchronized (map) {
            if (!this.scheduledExecutors.containsKey(name)) {
                this.scheduledExecutors.put(name, Executors.newScheduledThreadPool(numThread, new SchedulerThreadFactory(name)));
            }
            return this.scheduledExecutors.get(name);
        }
    }

    public ExecutorService getNoteJobExecutor() {
        return this.createOrGet("NoteJobThread-", 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String name) {
        ExecutorService e;
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            if (this.executors.containsKey(name)) {
                e = this.executors.get(name);
                ExecutorUtil.softShutdown(name, e, 1, TimeUnit.MINUTES);
                this.executors.remove(name);
            }
        }
        map = this.scheduledExecutors;
        synchronized (map) {
            if (this.scheduledExecutors.containsKey(name)) {
                e = this.scheduledExecutors.get(name);
                ExecutorUtil.softShutdown(name, e, 1, TimeUnit.MINUTES);
                this.scheduledExecutors.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAll() {
        Map<String, ExecutorService> map = this.executors;
        synchronized (map) {
            for (Map.Entry<String, ExecutorService> entry : this.executors.entrySet()) {
                ExecutorUtil.softShutdown(entry.getKey(), entry.getValue(), 1, TimeUnit.MINUTES);
            }
            this.executors.clear();
        }
        map = this.scheduledExecutors;
        synchronized (map) {
            for (Map.Entry<String, ExecutorService> entry : this.scheduledExecutors.entrySet()) {
                ExecutorUtil.softShutdown(entry.getKey(), entry.getValue(), 1, TimeUnit.MINUTES);
            }
            this.scheduledExecutors.clear();
        }
    }

    private static final class InstanceHolder {
        private static final ExecutorFactory INSTANCE = new ExecutorFactory();

        private InstanceHolder() {
        }
    }
}

