/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorUtil.class);

    private ExecutorUtil() {
    }

    public static void softShutdown(String name, ExecutorService executor, int stopTimeoutVal, TimeUnit stopTimeoutUnit) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(stopTimeoutVal, stopTimeoutUnit)) {
                LOGGER.warn("{} was not shut down in the given time {} {} - interrupting now", new Object[]{name, stopTimeoutVal, stopTimeoutUnit});
                executor.shutdownNow();
                if (!executor.awaitTermination(stopTimeoutVal, stopTimeoutUnit)) {
                    LOGGER.error("executor {} did not terminate", (Object)name);
                }
            }
        }
        catch (InterruptedException ie) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

