/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.rest;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.annotation.ZeppelinApi;
import org.apache.zeppelin.interpreter.InterpreterSetting;
import org.apache.zeppelin.notebook.Note;
import org.apache.zeppelin.notebook.Notebook;
import org.apache.zeppelin.notebook.NotebookAuthorization;
import org.apache.zeppelin.notebook.Paragraph;
import org.apache.zeppelin.rest.message.CronRequest;
import org.apache.zeppelin.rest.message.InterpreterSettingListForNoteBind;
import org.apache.zeppelin.rest.message.NewNotebookRequest;
import org.apache.zeppelin.rest.message.NewParagraphRequest;
import org.apache.zeppelin.rest.message.RunParagraphWithParametersRequest;
import org.apache.zeppelin.search.SearchService;
import org.apache.zeppelin.server.JsonResponse;
import org.apache.zeppelin.socket.NotebookServer;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.apache.zeppelin.utils.SecurityUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notebook")
@Produces(value={"application/json"})
public class NotebookRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(NotebookRestApi.class);
    Gson gson = new Gson();
    private Notebook notebook;
    private NotebookServer notebookServer;
    private SearchService notebookIndex;
    private NotebookAuthorization notebookAuthorization;

    public NotebookRestApi() {
    }

    public NotebookRestApi(Notebook notebook, NotebookServer notebookServer, SearchService search) {
        this.notebook = notebook;
        this.notebookServer = notebookServer;
        this.notebookIndex = search;
        this.notebookAuthorization = notebook.getNotebookAuthorization();
    }

    @GET
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response getNotePermissions(@PathParam(value="noteId") String noteId) {
        Note note = this.notebook.getNote(noteId);
        HashMap<String, Set> permissionsMap = new HashMap<String, Set>();
        permissionsMap.put("owners", this.notebookAuthorization.getOwners(noteId));
        permissionsMap.put("readers", this.notebookAuthorization.getReaders(noteId));
        permissionsMap.put("writers", this.notebookAuthorization.getWriters(noteId));
        return new JsonResponse(Response.Status.OK, "", permissionsMap).build();
    }

    String ownerPermissionError(Set<String> current, Set<String> allowed) throws IOException {
        LOG.info("Cannot change permissions. Connection owners {}. Allowed owners {}", (Object)current.toString(), (Object)allowed.toString());
        return "Insufficient privileges to change permissions.\n\nAllowed owners: " + allowed.toString() + "\n\n" + "User belongs to: " + current.toString();
    }

    @PUT
    @Path(value="{noteId}/permissions")
    @ZeppelinApi
    public Response putNotePermissions(@PathParam(value="noteId") String noteId, String req) throws IOException {
        HashMap permMap = (HashMap)this.gson.fromJson(req, new TypeToken<HashMap<String, HashSet>>(){}.getType());
        Note note = this.notebook.getNote(noteId);
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        LOG.info("Set permissions {} {} {} {} {}", new Object[]{noteId, principal, permMap.get("owners"), permMap.get("readers"), permMap.get("writers")});
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        if (!this.notebookAuthorization.isOwner(noteId, userAndRoles)) {
            return new JsonResponse(Response.Status.FORBIDDEN, this.ownerPermissionError(userAndRoles, this.notebookAuthorization.getOwners(noteId))).build();
        }
        HashSet readers = (HashSet)permMap.get("readers");
        HashSet owners = (HashSet)permMap.get("owners");
        HashSet writers = (HashSet)permMap.get("writers");
        if (readers != null && !readers.isEmpty()) {
            if (writers.isEmpty()) {
                writers = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
            }
            if (owners.isEmpty()) {
                owners = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
            }
        }
        if (writers != null && !writers.isEmpty() && owners.isEmpty()) {
            owners = Sets.newHashSet((Object[])new String[]{SecurityUtils.getPrincipal()});
        }
        this.notebookAuthorization.setReaders(noteId, (Set)readers);
        this.notebookAuthorization.setWriters(noteId, (Set)writers);
        this.notebookAuthorization.setOwners(noteId, (Set)owners);
        LOG.debug("After set permissions {} {} {}", new Object[]{this.notebookAuthorization.getOwners(noteId), this.notebookAuthorization.getReaders(noteId), this.notebookAuthorization.getWriters(noteId)});
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse(Response.Status.OK).build();
    }

    @PUT
    @Path(value="interpreter/bind/{noteId}")
    @ZeppelinApi
    public Response bind(@PathParam(value="noteId") String noteId, String req) throws IOException {
        List settingIdList = (List)this.gson.fromJson(req, new TypeToken<List<String>>(){}.getType());
        this.notebook.bindInterpretersToNote(noteId, settingIdList);
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="interpreter/bind/{noteId}")
    @ZeppelinApi
    public Response bind(@PathParam(value="noteId") String noteId) {
        LinkedList<InterpreterSettingListForNoteBind> settingList = new LinkedList<InterpreterSettingListForNoteBind>();
        List selectedSettings = this.notebook.getBindedInterpreterSettings(noteId);
        for (InterpreterSetting setting : selectedSettings) {
            settingList.add(new InterpreterSettingListForNoteBind(setting.id(), setting.getName(), setting.getGroup(), setting.getInterpreterInfos(), true));
        }
        List availableSettings = this.notebook.getInterpreterFactory().get();
        for (InterpreterSetting setting : availableSettings) {
            boolean selected = false;
            for (InterpreterSetting selectedSetting : selectedSettings) {
                if (!selectedSetting.id().equals(setting.id())) continue;
                selected = true;
                break;
            }
            if (selected) continue;
            settingList.add(new InterpreterSettingListForNoteBind(setting.id(), setting.getName(), setting.getGroup(), setting.getInterpreterInfos(), false));
        }
        return new JsonResponse(Response.Status.OK, "", settingList).build();
    }

    @GET
    @Path(value="/")
    @ZeppelinApi
    public Response getNotebookList() throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        List<Map<String, String>> notesInfo = this.notebookServer.generateNotebooksInfo(false, subject);
        return new JsonResponse<List<Map<String, String>>>(Response.Status.OK, "", notesInfo).build();
    }

    @GET
    @Path(value="{notebookId}")
    @ZeppelinApi
    public Response getNotebook(@PathParam(value="notebookId") String notebookId) throws IOException {
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        return new JsonResponse<Note>(Response.Status.OK, "", note).build();
    }

    @GET
    @Path(value="export/{id}")
    @ZeppelinApi
    public Response exportNoteBook(@PathParam(value="id") String noteId) throws IOException {
        String exportJson = this.notebook.exportNote(noteId);
        return new JsonResponse<String>(Response.Status.OK, "", exportJson).build();
    }

    @POST
    @Path(value="import")
    @ZeppelinApi
    public Response importNotebook(String req) throws IOException {
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note newNote = this.notebook.importNote(req, null, subject);
        return new JsonResponse<String>(Response.Status.CREATED, "", newNote.getId()).build();
    }

    @POST
    @Path(value="/")
    @ZeppelinApi
    public Response createNote(String message) throws IOException {
        LOG.info("Create new notebook by JSON {}", (Object)message);
        NewNotebookRequest request = (NewNotebookRequest)this.gson.fromJson(message, NewNotebookRequest.class);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note note = this.notebook.createNote(subject);
        List<NewParagraphRequest> initialParagraphs = request.getParagraphs();
        if (initialParagraphs != null) {
            for (NewParagraphRequest paragraphRequest : initialParagraphs) {
                Paragraph p = note.addParagraph();
                p.setTitle(paragraphRequest.getTitle());
                p.setText(paragraphRequest.getText());
            }
        }
        note.addParagraph();
        String noteName = request.getName();
        if (noteName.isEmpty()) {
            noteName = "Note " + note.getId();
        }
        note.setName(noteName);
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        this.notebookServer.broadcastNoteList(subject);
        return new JsonResponse<String>(Response.Status.CREATED, "", note.getId()).build();
    }

    @DELETE
    @Path(value="{notebookId}")
    @ZeppelinApi
    public Response deleteNote(@PathParam(value="notebookId") String notebookId) throws IOException {
        Note note;
        LOG.info("Delete notebook {} ", (Object)notebookId);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        if (!notebookId.isEmpty() && (note = this.notebook.getNote(notebookId)) != null) {
            this.notebook.removeNote(notebookId, subject);
        }
        this.notebookServer.broadcastNoteList(subject);
        return new JsonResponse(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="{notebookId}")
    @ZeppelinApi
    public Response cloneNote(@PathParam(value="notebookId") String notebookId, String message) throws IOException, CloneNotSupportedException, IllegalArgumentException {
        LOG.info("clone notebook by JSON {}", (Object)message);
        NewNotebookRequest request = (NewNotebookRequest)this.gson.fromJson(message, NewNotebookRequest.class);
        String newNoteName = request.getName();
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        Note newNote = this.notebook.cloneNote(notebookId, newNoteName, subject);
        this.notebookServer.broadcastNote(newNote);
        this.notebookServer.broadcastNoteList(subject);
        return new JsonResponse<String>(Response.Status.CREATED, "", newNote.getId()).build();
    }

    @POST
    @Path(value="{notebookId}/paragraph")
    @ZeppelinApi
    public Response insertParagraph(@PathParam(value="notebookId") String notebookId, String message) throws IOException {
        LOG.info("insert paragraph {} {}", (Object)notebookId, (Object)message);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        NewParagraphRequest request = (NewParagraphRequest)this.gson.fromJson(message, NewParagraphRequest.class);
        Double indexDouble = request.getIndex();
        Paragraph p = indexDouble == null ? note.addParagraph() : note.insertParagraph(indexDouble.intValue());
        p.setTitle(request.getTitle());
        p.setText(request.getText());
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse<String>(Response.Status.CREATED, "", p.getId()).build();
    }

    @GET
    @Path(value="{notebookId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response getParagraph(@PathParam(value="notebookId") String notebookId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("get paragraph {} {}", (Object)notebookId, (Object)paragraphId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "paragraph not found.").build();
        }
        return new JsonResponse<Paragraph>(Response.Status.OK, "", p).build();
    }

    @POST
    @Path(value="{notebookId}/paragraph/{paragraphId}/move/{newIndex}")
    @ZeppelinApi
    public Response moveParagraph(@PathParam(value="notebookId") String notebookId, @PathParam(value="paragraphId") String paragraphId, @PathParam(value="newIndex") String newIndex) throws IOException {
        LOG.info("move paragraph {} {} {}", new Object[]{notebookId, paragraphId, newIndex});
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "paragraph not found.").build();
        }
        try {
            note.moveParagraph(paragraphId, Integer.parseInt(newIndex), true);
            AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
            note.persist(subject);
            this.notebookServer.broadcastNote(note);
            return new JsonResponse(Response.Status.OK, "").build();
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error("Exception in NotebookRestApi while moveParagraph ", (Throwable)e);
            return new JsonResponse(Response.Status.BAD_REQUEST, "paragraph's new index is out of bound").build();
        }
    }

    @DELETE
    @Path(value="{notebookId}/paragraph/{paragraphId}")
    @ZeppelinApi
    public Response deleteParagraph(@PathParam(value="notebookId") String notebookId, @PathParam(value="paragraphId") String paragraphId) throws IOException {
        LOG.info("delete paragraph {} {}", (Object)notebookId, (Object)paragraphId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "paragraph not found.").build();
        }
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        note.removeParagraph(paragraphId);
        note.persist(subject);
        this.notebookServer.broadcastNote(note);
        return new JsonResponse(Response.Status.OK, "").build();
    }

    @POST
    @Path(value="job/{notebookId}")
    @ZeppelinApi
    public Response runNoteJobs(@PathParam(value="notebookId") String notebookId) throws IOException, IllegalArgumentException {
        LOG.info("run notebook jobs {} ", (Object)notebookId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        try {
            note.runAll();
        }
        catch (Exception ex) {
            LOG.error("Exception from run", (Throwable)ex);
            return new JsonResponse(Response.Status.PRECONDITION_FAILED, ex.getMessage() + "- Not selected or Invalid Interpreter bind").build();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="job/{notebookId}")
    @ZeppelinApi
    public Response stopNoteJobs(@PathParam(value="notebookId") String notebookId) throws IOException, IllegalArgumentException {
        LOG.info("stop notebook jobs {} ", (Object)notebookId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        for (Paragraph p : note.getParagraphs()) {
            if (p.isTerminated()) continue;
            p.abort();
        }
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="job/{notebookId}")
    @ZeppelinApi
    public Response getNoteJobStatus(@PathParam(value="notebookId") String notebookId) throws IOException, IllegalArgumentException {
        LOG.info("get notebook job status.");
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        return new JsonResponse<List>(Response.Status.OK, null, note.generateParagraphsInfo()).build();
    }

    @POST
    @Path(value="job/{notebookId}/{paragraphId}")
    @ZeppelinApi
    public Response runParagraph(@PathParam(value="notebookId") String notebookId, @PathParam(value="paragraphId") String paragraphId, String message) throws IOException, IllegalArgumentException {
        RunParagraphWithParametersRequest request;
        Map<String, Object> paramsForUpdating;
        LOG.info("run paragraph job {} {} {}", new Object[]{notebookId, paragraphId, message});
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Paragraph paragraph = note.getParagraph(paragraphId);
        if (paragraph == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "paragraph not found.").build();
        }
        if (!StringUtils.isEmpty((CharSequence)message) && (paramsForUpdating = (request = (RunParagraphWithParametersRequest)this.gson.fromJson(message, RunParagraphWithParametersRequest.class)).getParams()) != null) {
            paragraph.settings.getParams().putAll(paramsForUpdating);
            AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
            note.persist(subject);
        }
        note.run(paragraph.getId());
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="job/{notebookId}/{paragraphId}")
    @ZeppelinApi
    public Response stopParagraph(@PathParam(value="notebookId") String notebookId, @PathParam(value="paragraphId") String paragraphId) throws IOException, IllegalArgumentException {
        LOG.info("stop paragraph job {} ", (Object)notebookId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Paragraph p = note.getParagraph(paragraphId);
        if (p == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "paragraph not found.").build();
        }
        p.abort();
        return new JsonResponse(Response.Status.OK).build();
    }

    @POST
    @Path(value="cron/{notebookId}")
    @ZeppelinApi
    public Response registerCronJob(@PathParam(value="notebookId") String notebookId, String message) throws IOException, IllegalArgumentException {
        LOG.info("Register cron job note={} request cron msg={}", (Object)notebookId, (Object)message);
        CronRequest request = (CronRequest)this.gson.fromJson(message, CronRequest.class);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        if (!CronExpression.isValidExpression((String)request.getCronString())) {
            return new JsonResponse(Response.Status.BAD_REQUEST, "wrong cron expressions.").build();
        }
        Map config = note.getConfig();
        config.put("cron", request.getCronString());
        note.setConfig(config);
        this.notebook.refreshCron(note.id());
        return new JsonResponse(Response.Status.OK).build();
    }

    @DELETE
    @Path(value="cron/{notebookId}")
    @ZeppelinApi
    public Response removeCronJob(@PathParam(value="notebookId") String notebookId) throws IOException, IllegalArgumentException {
        LOG.info("Remove cron job note {}", (Object)notebookId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        Map config = note.getConfig();
        config.put("cron", null);
        note.setConfig(config);
        this.notebook.refreshCron(note.id());
        return new JsonResponse(Response.Status.OK).build();
    }

    @GET
    @Path(value="cron/{notebookId}")
    @ZeppelinApi
    public Response getCronJob(@PathParam(value="notebookId") String notebookId) throws IOException, IllegalArgumentException {
        LOG.info("Get cron job note {}", (Object)notebookId);
        Note note = this.notebook.getNote(notebookId);
        if (note == null) {
            return new JsonResponse(Response.Status.NOT_FOUND, "note not found.").build();
        }
        return new JsonResponse(Response.Status.OK, note.getConfig().get("cron")).build();
    }

    @GET
    @Path(value="jobmanager/")
    @ZeppelinApi
    public Response getJobListforNotebook() throws IOException, IllegalArgumentException {
        LOG.info("Get notebook jobs for job manager");
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        List notebookJobs = this.notebook.getJobListforNotebook(false, 0L, subject);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", notebookJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="jobmanager/{lastUpdateUnixtime}/")
    @ZeppelinApi
    public Response getUpdatedJobListforNotebook(@PathParam(value="lastUpdateUnixtime") long lastUpdateUnixTime) throws IOException, IllegalArgumentException {
        LOG.info("Get updated notebook jobs lastUpdateTime {}", (Object)lastUpdateUnixTime);
        AuthenticationInfo subject = new AuthenticationInfo(SecurityUtils.getPrincipal());
        List notebookJobs = this.notebook.getJobListforNotebook(false, lastUpdateUnixTime, subject);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("lastResponseUnixTime", System.currentTimeMillis());
        response.put("jobs", notebookJobs);
        return new JsonResponse(Response.Status.OK, response).build();
    }

    @GET
    @Path(value="search")
    @ZeppelinApi
    public Response search(@QueryParam(value="q") String queryTerm) {
        LOG.info("Searching notebooks for: {}", (Object)queryTerm);
        String principal = SecurityUtils.getPrincipal();
        HashSet<String> roles = SecurityUtils.getRoles();
        HashSet<String> userAndRoles = new HashSet<String>();
        userAndRoles.add(principal);
        userAndRoles.addAll(roles);
        List notebooksFound = this.notebookIndex.query(queryTerm);
        for (int i = 0; i < notebooksFound.size(); ++i) {
            String[] Id = ((String)((Map)notebooksFound.get(i)).get("id")).split("/", 2);
            String noteId = Id[0];
            if (this.notebookAuthorization.isOwner(noteId, userAndRoles) || this.notebookAuthorization.isReader(noteId, userAndRoles) || this.notebookAuthorization.isWriter(noteId, userAndRoles)) continue;
            notebooksFound.remove(i);
            --i;
        }
        LOG.info("{} notebooks found", (Object)notebooksFound.size());
        return new JsonResponse<List>(Response.Status.OK, notebooksFound).build();
    }
}

